/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.util.LineCounter;
import java.io.IOException;
import java.io.InputStream;

public class LineCountingInputStream
extends InputStream {
    private DiffTextCache diffTextCache;
    private LineCounter counter = new LineCounter();
    private InputStream input;
    private CharMode charMode;
    private int firstByte;
    private boolean partialCharPresent;
    private boolean lastWasCR;

    public LineCountingInputStream(InputStream input, CharMode charMode, DiffTextCache diffTextCache) {
        this.input = input;
        this.charMode = charMode;
        this.diffTextCache = diffTextCache;
    }

    public LineCountingInputStream(InputStream input) {
        this(input, CharMode.BYTES, null);
    }

    @Override
    public int read() throws IOException {
        int ch = this.input.read();
        this.processByte(ch);
        return ch;
    }

    private void processByte(int ch) throws IOException {
        if (this.diffTextCache != null) {
            this.diffTextCache.addByte((byte)ch);
        }
        if (this.charMode == CharMode.BYTES || this.lastWasCR && ch == 10) {
            this.counter.process(ch);
        } else if (this.partialCharPresent) {
            switch (this.charMode) {
                case BOM: {
                    if (this.firstByte == -2 && ch == -1) {
                        this.charMode = CharMode.BIG_ENDIAN;
                    } else if (this.firstByte == -1 && ch == -2) {
                        this.charMode = CharMode.LITTLE_ENDIAN;
                    } else {
                        this.charMode = CharMode.LITTLE_ENDIAN;
                        int b2 = ch << 8 | this.firstByte;
                        this.processChar(b2);
                    }
                    this.partialCharPresent = false;
                    break;
                }
                case LITTLE_ENDIAN: {
                    int leChar = ch << 8 | this.firstByte;
                    this.processChar(leChar);
                    this.partialCharPresent = false;
                    break;
                }
                case BIG_ENDIAN: {
                    int beChar = this.firstByte << 8 | ch;
                    this.processChar(beChar);
                    this.partialCharPresent = false;
                }
            }
        } else {
            this.partialCharPresent = true;
            this.firstByte = ch;
        }
    }

    private void processChar(int ch) throws IOException {
        this.counter.process(ch);
        this.lastWasCR = ch == 13;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int numRead = this.input.read(b2, off, len);
        for (int i2 = off; i2 < off + numRead; ++i2) {
            this.processByte(b2[i2]);
        }
        return numRead;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    public int getLineCount() throws IOException {
        return this.counter.getLineCount();
    }

    public void readFully() throws IOException {
        byte[] buffer = new byte[8192];
        while (this.read(buffer) != -1) {
        }
    }

    public static enum CharMode {
        BYTES,
        LITTLE_ENDIAN,
        BIG_ENDIAN,
        BOM;

    }
}

