/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.io.IOException;

public class LineCounter {
    private int lineCount = 0;
    private long charCount;
    private boolean lastWasCR;
    private int colCount = 0;

    public boolean process(int b2) throws IOException {
        ++this.charCount;
        boolean eol = false;
        if (b2 == 10) {
            if (this.lastWasCR) {
                this.lastWasCR = false;
            } else {
                if (this.colCount == 0) {
                    ++this.lineCount;
                }
                eol = true;
            }
        } else if (b2 == 13) {
            if (this.colCount == 0) {
                ++this.lineCount;
            }
            eol = true;
            this.lastWasCR = true;
        } else {
            if (this.colCount == 0) {
                ++this.lineCount;
            }
            ++this.colCount;
            this.lastWasCR = false;
        }
        if (eol) {
            this.colCount = 0;
        }
        return eol;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public long getCharCount() {
        return this.charCount;
    }

    public void reset() {
        this.resetCount();
        this.lastWasCR = false;
    }

    public void resetCount() {
        this.lineCount = 0;
        this.charCount = 0L;
        this.colCount = 0;
    }
}

