/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Interval;
import com.google.common.base.Strings;
import org.apache.commons.lang.StringUtils;

public final class IntervalUtils {
    public static long convertStringToLong(String s2, long defaultValue) {
        long value = defaultValue;
        if (!Strings.nullToEmpty((String)s2).trim().isEmpty()) {
            try {
                value = new Interval(s2).getValueInMillis();
            }
            catch (NumberFormatException ex) {
                Logs.APP_LOG.warn((Object)("could not parse string: " + s2), (Throwable)ex);
            }
        }
        return value;
    }

    public static long convertStringToLongOrNever(String s2, long defaultValue) {
        if ("never".equalsIgnoreCase(Strings.nullToEmpty((String)s2).trim())) {
            return 0L;
        }
        return IntervalUtils.convertStringToLong(s2, defaultValue);
    }

    public static String toMsStringWithDefault(String purpose, String interval, String defaultInterval) {
        String msString = null;
        if (!StringUtils.isBlank((String)interval)) {
            msString = IntervalUtils.toMsString(interval);
        }
        if (msString == null) {
            Logs.APP_LOG.warn((Object)("Invalid " + purpose + " interval: '" + interval + "', using default '" + defaultInterval + "'"));
            msString = IntervalUtils.toMsString(defaultInterval);
            if (msString == null) {
                Logs.APP_LOG.error((Object)("Invalid default interval: '" + defaultInterval + "'"));
            }
        }
        return msString;
    }

    private static String toMsString(String interval) {
        try {
            Interval i2 = new Interval(interval);
            return Long.toString(i2.getValueInMillis());
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }
}

