/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ISO8601DateHelper {
    public static final String FORMAT_ISO8601_WITH_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final Pattern PARSER = Pattern.compile("(\\d\\d(\\d\\d)?)-?(\\d\\d)-?(\\d\\d)([T ](\\d\\d):?(\\d\\d):?(\\d\\d)(\\.(\\d+))?)?(Z|((\\+|-)?(\\d\\d)(:?(\\d\\d))?))?$", 2);

    public static Date parseAsTimeZone(String s2, TimeZone tz) throws InvalidDateException {
        return ISO8601DateHelper.parse(s2, tz);
    }

    public static Date parseAsUTC(String s2) throws InvalidDateException {
        return ISO8601DateHelper.parse(s2, TimeZone.getTimeZone("GMT"));
    }

    private static Date parse(String s2, TimeZone tz) throws InvalidDateException {
        Matcher m2 = PARSER.matcher(s2);
        if (!m2.matches()) {
            throw new InvalidDateException("date [" + s2 + "] did not match pattern [" + PARSER.toString() + "]");
        }
        int year = Integer.parseInt(m2.group(1));
        if (m2.group(2) == null) {
            year += 1900;
        }
        int month = Integer.parseInt(m2.group(3));
        int day = Integer.parseInt(m2.group(4));
        int hour = 0;
        int min = 0;
        int sec = 0;
        if (m2.group(5) != null) {
            hour = Integer.parseInt(m2.group(6));
            min = Integer.parseInt(m2.group(7));
            sec = Integer.parseInt(m2.group(8));
        }
        int msec = 0;
        if (m2.group(9) != null) {
            float secFrac = Float.parseFloat(m2.group(9));
            msec = (int)(secFrac * 1000.0f);
        }
        TimeZone timeZone = tz = m2.group(11) == null ? tz : TimeZone.getTimeZone("GMT");
        if (m2.group(12) != null) {
            boolean plus = m2.group(13) == null || m2.group(13).equals("+");
            String tzhh = m2.group(14);
            String tzmm = m2.group(16);
            if (tzmm == null) {
                tzmm = "00";
            }
            tz = TimeZone.getTimeZone("GMT" + (plus ? "+" : "-") + tzhh + ":" + tzmm);
        }
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.clear();
        cal.set(year, month - 1, day, hour, min, sec);
        cal.set(14, msec);
        return cal.getTime();
    }

    public static String toIsoDate(Date date) {
        if (date == null) {
            return "";
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        StringBuilder buffer = new StringBuilder();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(5)));
        buffer.append("T");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(13)));
        buffer.append(".");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(14) / 10));
        buffer.append("Z");
        return buffer.toString();
    }

    public static String toIsoDate(long date) {
        return ISO8601DateHelper.toIsoDate(new Date(date));
    }

    @Nullable
    public static String toIsoDateWithTz(Date date) {
        return date == null ? null : new SimpleDateFormat(FORMAT_ISO8601_WITH_TZ).format(date);
    }

    @Nullable
    public static String toIsoDateWithTz(Long date) {
        return date == null ? null : ISO8601DateHelper.toIsoDateWithTz(new Date(date));
    }

    private static String twoDigit(int i2) {
        if (i2 >= 0 && i2 < 10) {
            return "0" + String.valueOf(i2);
        }
        return String.valueOf(i2);
    }

    public static String toXmlRpcDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        StringBuffer buffer = new StringBuffer();
        buffer.append(calendar.get(1));
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(2) + 1));
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(5)));
        buffer.append("T");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(ISO8601DateHelper.twoDigit(calendar.get(13)));
        return buffer.toString();
    }

    public static String toXmlRpcDate(long date) {
        return ISO8601DateHelper.toXmlRpcDate(new Date(date));
    }

    public static Date addWorkingDays(Date startUtc, int workingDays, TimeZone tz) {
        int fullWeekend;
        int weekendDaysFromSunday;
        int weekendDaysFromSaturday;
        int lastDayBeforeWeekend;
        if (workingDays == 0) {
            return startUtc;
        }
        if (workingDays < 0) {
            lastDayBeforeWeekend = 2;
            weekendDaysFromSaturday = -1;
            weekendDaysFromSunday = -2;
            fullWeekend = -2;
        } else {
            lastDayBeforeWeekend = 6;
            weekendDaysFromSaturday = 2;
            weekendDaysFromSunday = 1;
            fullWeekend = 2;
        }
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.setTime(startUtc);
        int startDay = cal.get(7);
        int fullWeeks = workingDays / 5;
        int weekendDays = fullWeeks * 2;
        if (startDay == 7) {
            weekendDays += weekendDaysFromSaturday;
        } else if (startDay == 1) {
            weekendDays += weekendDaysFromSunday;
        } else {
            boolean remainderIncludesAWeekend;
            int remainderWorkingDays = Math.abs(workingDays % 5);
            int remainderDaysTilWeekend = Math.abs(lastDayBeforeWeekend - startDay);
            boolean bl = remainderIncludesAWeekend = remainderDaysTilWeekend < remainderWorkingDays;
            if (remainderIncludesAWeekend) {
                weekendDays += fullWeekend;
            }
        }
        cal.add(7, workingDays + weekendDays);
        return cal.getTime();
    }

    public static int getElapsedWorkingDays(Date startUtc, Date endUtc, TimeZone tz) {
        if (endUtc == null || startUtc == null) {
            throw new IllegalArgumentException("start and end cannot be null.");
        }
        if (endUtc.before(startUtc)) {
            return -ISO8601DateHelper.getElapsedWorkingDays(endUtc, startUtc, tz);
        }
        int weekdays = 0;
        GregorianCalendar startCal = new GregorianCalendar(tz);
        startCal.setTime(startUtc);
        GregorianCalendar currCal = new GregorianCalendar(tz);
        currCal.setTime(endUtc);
        while (!currCal.before(startCal)) {
            int currentDay = currCal.get(7);
            if (currentDay != 7 && currentDay != 1) {
                ++weekdays;
            }
            currCal.add(7, -1);
        }
        weekdays = Math.max(weekdays - 1, 0);
        return weekdays;
    }

    public static class InvalidDateException
    extends Exception {
        public InvalidDateException(String message) {
            super(message);
        }
    }
}

