/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    public static final String DEFAULT_HASHING_ALGORITHM = "SHA-256";

    public static String getDefaultDigestHexEncoded(String value) {
        return StringUtil.hexEncode(HashUtils.getDefaultDigest(value), true);
    }

    public static byte[] getDefaultDigest(String value) {
        return HashUtils.getMessageDigest(DEFAULT_HASHING_ALGORITHM).digest(StringUtil.getBytesInUTF8(value));
    }

    public static byte[] getSha1Digest(String value) {
        return HashUtils.getMessageDigest("SHA-1").digest(StringUtil.getBytesInUTF8(value));
    }

    public static MessageDigest getMessageDigest(String digestName) {
        try {
            return MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(digestName + " digest algorithm was not found in this JVM");
        }
    }
}

