/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.io.File;
import java.io.IOException;

public class FileUtils {
    private static final long KILO = 1024L;
    private static final long MEGA = 0x100000L;
    private static final long GIGA = 0x40000000L;
    private static final long TERA = 0x10000000000L;
    private static final long PETA = 0x4000000000000L;
    private static final long EXA = 0x1000000000000000L;

    public static boolean deleteTree(File dir) {
        if (dir != null && dir.exists()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        FileUtils.deleteTree(file);
                        continue;
                    }
                    file.delete();
                }
            }
            return dir.delete();
        }
        return false;
    }

    public static File createTempDir(File base, String prefix) throws IOException {
        File tempDir = File.createTempFile(prefix, "", base);
        if (!tempDir.delete()) {
            throw new IOException("Could not delete temp file in order to turn it into a temp directory");
        }
        if (!tempDir.mkdirs()) {
            throw new IOException("Could not perform mkdirs on temp file path");
        }
        return tempDir;
    }

    public static String formatFileSize(long size) throws IllegalArgumentException {
        String term;
        long squashed;
        if (size < 0L) {
            throw new IllegalArgumentException("Illegal size: " + size);
        }
        if (size < 1000L) {
            squashed = size * 10L;
            term = "B";
        } else if (size / 1024L < 1000L) {
            squashed = size * 10L / 1024L;
            term = "K";
        } else if (size / 0x100000L < 1000L) {
            squashed = size * 10L / 0x100000L;
            term = "M";
        } else if (size / 0x40000000L < 1000L) {
            squashed = size * 10L / 0x40000000L;
            term = "G";
        } else if (size / 0x10000000000L < 1000L) {
            squashed = size * 10L / 0x10000000000L;
            term = "T";
        } else if (size / 0x4000000000000L < 1000L) {
            squashed = size * 10L / 0x4000000000000L;
            term = "P";
        } else {
            squashed = size / 0x199999999999999L;
            term = "E";
        }
        return (squashed == 0L || squashed >= 10L ? Long.valueOf(squashed / 10L) : "0." + squashed) + term;
    }

    public static String normaliseSeparators(String s2) {
        return s2.replaceAll("\\\\", "/");
    }
}

