/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Component;

@Component(value="fileSystemUtils")
public class FileSystemUtils {
    public File searchPath(String ... executableNames) throws IOException {
        String path = System.getenv("PATH");
        if (path != null) {
            String[] p2;
            for (String pathElt : p2 = path.split(File.pathSeparator)) {
                for (String ex : executableNames) {
                    File pef = new File(pathElt, ex);
                    if (!pef.exists()) continue;
                    return pef.getCanonicalFile();
                }
            }
        }
        return null;
    }

    public void privatise(File file) throws IOException {
        boolean ret = file.setReadable(false, false);
        ret &= file.setWritable(false, false);
        ret &= file.setExecutable(false, false);
        ret &= file.setReadable(true, true);
        ret &= file.setWritable(true, true);
        boolean isDir = file.isDirectory();
        if (isDir) {
            ret &= file.setExecutable(true, true);
        }
        if (!ret) {
            Logs.APP_LOG.debug((Object)String.format("Failed to ensure %s \"%s\" is only owner accessible.", isDir ? "directory" : "file", file.getAbsolutePath(), AppConfig.getInstanceDir().getAbsolutePath()));
        }
    }

    public String spaceEscapeFilePath(String path) {
        if (path == null) {
            return null;
        }
        return "\"" + path + "\"";
    }
}

