/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class EmailUtil {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4})");

    public static String extractEmail(String commiterName) {
        Matcher matcher = EMAIL_PATTERN.matcher(commiterName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String wrapEmail(String email) {
        if (StringUtils.isNotBlank((String)email)) {
            return "<" + email + ">";
        }
        return email;
    }

    public static boolean isValidEmail(String email) {
        if (email != null) {
            return EMAIL_PATTERN.matcher(email).matches();
        }
        return false;
    }
}

