/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Disposable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class Disposer {
    private static final ThreadLocal<LinkedList<Disposer>> mPerThreadStack = new ThreadLocal<LinkedList<Disposer>>(){

        @Override
        protected LinkedList<Disposer> initialValue() {
            return new LinkedList<Disposer>();
        }
    };
    public static final String NO_DISPOSER_MESSAGE = "A disposer has not been initialized for this thread";
    private final LinkedList<Disposable> mDisposables = new LinkedList();

    public void deleteFileOnDispose(final File file) {
        this.add(new Disposable(){

            @Override
            public void dispose() throws Exception {
                file.delete();
            }
        });
    }

    public File newDisposedTmpFile() throws IOException {
        File tmpFile = File.createTempFile("fecru", null);
        this.deleteFileOnDispose(tmpFile);
        return tmpFile;
    }

    public void closeOnDispose(final InputStream in) {
        this.add(new Disposable(){

            @Override
            public void dispose() throws Exception {
                in.close();
            }
        });
    }

    public void disposeOnDispose(final Disposer disposer) {
        this.add(new Disposable(){

            @Override
            public void dispose() throws Exception {
                disposer.disposeAll();
            }
        });
    }

    public void add(Disposable d2) {
        if (d2 == null) {
            throw new IllegalArgumentException("Null Disposable added");
        }
        this.mDisposables.addFirst(d2);
    }

    public void disposeAll() {
        for (Disposable d2 : this.mDisposables) {
            try {
                d2.dispose();
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)"error during disposal", (Throwable)e2);
            }
        }
        this.mDisposables.clear();
    }

    protected void finalize() throws Throwable {
        this.disposeAll();
        super.finalize();
    }

    public static Disposer threadInstance() {
        LinkedList<Disposer> stack = Disposer.validateDisposerStack();
        return stack.getLast();
    }

    public static boolean hasThreadInstance() {
        return !mPerThreadStack.get().isEmpty();
    }

    private static LinkedList<Disposer> validateDisposerStack() {
        LinkedList<Disposer> stack = mPerThreadStack.get();
        if (stack.isEmpty()) {
            throw new IllegalStateException(NO_DISPOSER_MESSAGE);
        }
        return stack;
    }

    public static Disposer pushThreadInstance() {
        LinkedList<Disposer> stack = mPerThreadStack.get();
        Disposer d2 = new Disposer();
        stack.addLast(d2);
        return d2;
    }

    public static void popThreadInstance() {
        LinkedList<Disposer> stack = Disposer.validateDisposerStack();
        Disposer disposer = stack.removeLast();
        disposer.disposeAll();
    }

    public static void with(Runnable runnable) {
        Disposer.pushThreadInstance();
        try {
            runnable.run();
        }
        finally {
            Disposer.popThreadInstance();
        }
    }
}

