/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.atlassian.extras.common.LicenseException;
import com.atlassian.fecru.util.HttpClientFactory;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.util.ProductUpdateHttpException;
import com.cenqua.fisheye.util.ProductUpdateInfo;
import com.cenqua.fisheye.util.ProductUpdateInfoParser;
import com.cenqua.fisheye.util.ProductUpdateParseException;
import com.cenqua.fisheye.util.ProductUpdatePoller;
import com.cenqua.fisheye.util.VersionNumber;
import java.io.IOException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultProductUpdatePoller
implements ProductUpdatePoller {
    private final FisheyeVersionInfo currentVersion;
    private final ProductUpdateInfoParser updateParser;
    private final Timer timer = new Timer("ProductUpdatePoller", true);
    private TimerTask job = null;
    private ProductUpdateInfo latestVersion = null;
    private Date lastChecked = null;

    @Autowired
    protected DefaultProductUpdatePoller(RootConfig rootConfig) {
        this.currentVersion = new FisheyeVersionInfo();
        this.updateParser = new ProductUpdateInfoParser(this.currentVersion);
        if (rootConfig.getConfig().getCheckForUpdates().getEnabled()) {
            Interval minInterval = new Interval(1L, 1);
            Interval interval = new Interval(1L, 3);
            try {
                interval = new Interval(rootConfig.getConfig().getCheckForUpdates().getInterval());
                interval = minInterval.compareTo(interval) > 0 ? minInterval : interval;
            }
            catch (NumberFormatException e2) {
                Logs.APP_LOG.warn((Object)("Invalid interval specified for <checkForUpdates/>. Using " + interval.toString()));
            }
            this.enable(rootConfig.getConfig().getCheckForUpdates().getUrl(), interval);
        }
    }

    protected DefaultProductUpdatePoller(FisheyeVersionInfo currentVersion) {
        this.currentVersion = currentVersion;
        this.updateParser = new ProductUpdateInfoParser(currentVersion);
    }

    @Override
    public boolean getUpdateAvailable() {
        return this.isUpdateAvailable();
    }

    @Override
    public boolean isUpdateAvailable() {
        return this.latestVersion != null;
    }

    @Override
    public ProductUpdateInfo getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public Date getLastChecked() {
        return this.lastChecked;
    }

    @Override
    public synchronized void enable(final String url, Interval interval) {
        this.disable(false);
        this.job = new TimerTask(){

            @Override
            public void run() {
                try {
                    DefaultProductUpdatePoller.this.checkForUpdates(url);
                }
                catch (ProductUpdateHttpException e2) {
                    String errorMsg = "Error while checking for newer versions from " + url + " (" + e2.getMessage() + ")\n";
                    if (e2.isProxyError()) {
                        errorMsg = errorMsg + "Documentation for configuring FishEye/Crucible to use a proxy server is available at " + "https://confluence.atlassian.com/display/FISHEYE/Configuring+Outgoing+Web+Proxy+Support+for+FishEye+or+Crucible";
                    }
                    Logs.APP_LOG.error((Object)errorMsg, (Throwable)e2);
                }
                catch (Exception e3) {
                    Logs.APP_LOG.error((Object)("Error while checking for newer versions from " + url + " (" + e3.getMessage() + ")"), (Throwable)e3);
                }
            }
        };
        this.timer.schedule(this.job, 0L, interval.getValueInMillis());
        Logs.APP_LOG.info((Object)("Now checking for new software releases every " + interval.toString()));
    }

    @Override
    public synchronized void disable() {
        this.disable(true);
    }

    private synchronized void disable(boolean log) {
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        this.latestVersion = null;
        if (log) {
            Logs.APP_LOG.info((Object)"Automatic checking for new software releases has been disabled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkForUpdates(String url) throws ProductUpdateParseException, IOException, LicenseException, ProductUpdateHttpException {
        block4: {
            String updateUrl = url + (AppConfig.isCrucible() ? "/crucible.xml" : "/fisheye.xml");
            HttpClient client = HttpClientFactory.newHttpClient();
            GetMethod method = new GetMethod(updateUrl);
            try {
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode == 200) {
                    this.checkForUpdates(this.updateParser.parse(method.getResponseBodyAsStream()));
                    break block4;
                }
                boolean proxyError = statusCode == 407;
                throw new ProductUpdateHttpException(statusCode + " " + method.getStatusText(), statusCode, proxyError);
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    protected synchronized void checkForUpdates(ProductUpdateInfo update) {
        VersionNumber newNumber = new VersionNumber(update.getVersion());
        if (newNumber.compareTo(new VersionNumber(this.currentVersion.getReleaseNum())) > 0) {
            ProductUpdateInfo newVersion = new ProductUpdateInfo(update.getVersion(), update.getDownloadUrl(), update.getNeedAdditionalMaintenance(), update.getBuildDate());
            if (!newVersion.equals(this.latestVersion)) {
                Logs.APP_LOG.info((Object)String.format("You are not running the latest version of %s. Latest version %s can be downloaded at: %s", AppConfig.getProductName(), update.getVersion(), update.getDownloadUrl()));
                this.latestVersion = newVersion;
            }
        } else {
            this.latestVersion = null;
        }
        this.lastChecked = new Date();
    }
}

