/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import antlr.Token;
import antlr.TokenStreamException;
import com.cenqua.fisheye.search.query.QueryLangLexer;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedSet;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class DateHelper {
    public static final int HOURS_IN_DAY = 24;
    public static final int DAYS_IN_WEEK = 7;
    public static final int MINUTES_IN_HOUR = 60;
    public static final int MINUTES_IN_DAY = 1440;
    public static final long MS_IN_SECOND = 1000L;
    public static final long MS_IN_MINUTE = 60000L;
    public static final long MS_IN_HOUR = 3600000L;
    public static final long MS_IN_DAY = 86400000L;
    public static final long MS_IN_WEEK = 604800000L;
    public static final long MS_IN_MONTH = 2592000000L;
    public static final long MS_IN_YEAR = 31556925993L;
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final Set<String> AVAILABLE_TIMEZONE_IDS = ImmutableSortedSet.copyOf((Comparable[])TimeZone.getAvailableIDs());
    private static final String standardGmtDateFormat = "d MMM yyyy HH:mm:ss 'GMT'";
    private static final String canonicalFormat = "yyyyMMddHHmmssSSS";
    private static final DurationUnit DEFAULT_DURATION_UNIT = DurationUnit.MINUTE;
    private static final Pattern DURATION_REGEX = Pattern.compile("(-?\\d+(?:\\.\\d+)?|-?\\.\\d+) ?([a-z]*)");

    public static Map<String, String> getTimeSelectMap(int incrementsInMinutes) {
        if (incrementsInMinutes <= 0) {
            throw new IllegalArgumentException("increment should be greater than 0, got [" + incrementsInMinutes + "]");
        }
        DateTimeFormatter displayFormatter = new DateTimeFormatterBuilder().appendClockhourOfHalfday(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(' ').appendHalfdayOfDayText().toFormatter();
        DateTimeFormatter valueFormatter = new DateTimeFormatterBuilder().appendLiteral('T').appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2).toFormatter();
        DateTime dateTime = new DateTime(0, 1, 1, 0, 0, 0, 0);
        int numberOfIncrements = 1440 / incrementsInMinutes;
        LinkedHashMap<String, String> m2 = new LinkedHashMap<String, String>(numberOfIncrements);
        for (int i2 = 0; i2 < numberOfIncrements; ++i2) {
            m2.put(dateTime.toString(valueFormatter), dateTime.toString(displayFormatter));
            dateTime = dateTime.plusMinutes(incrementsInMinutes);
        }
        return m2;
    }

    public static String formatCanonicalDate(Date date) {
        return new SimpleDateFormat(canonicalFormat).format(date);
    }

    public static String formatDate(Date date, String pattern, TimeZone timezone) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        if (timezone != null) {
            formatter.setTimeZone(timezone);
        }
        return formatter.format(date);
    }

    public static String age(long birth, long now) {
        long dDaysRemainder;
        long dSecs;
        if (now < birth) {
            long tmp = now;
            now = birth;
            birth = tmp;
        }
        if ((dSecs = (now - birth) / 1000L) < 120L) {
            return DateHelper.durationToString(dSecs, "second");
        }
        long dMins = dSecs / 60L;
        if (dMins < 120L) {
            return DateHelper.durationToString(dMins, "minute");
        }
        long dHours = dMins / 60L;
        if (dHours < 72L) {
            return DateHelper.durationToString(dHours, "hour");
        }
        long dDays = dHours / 24L;
        if (dDays < 60L) {
            return DateHelper.durationToString(dDays, "day");
        }
        double dYearsVal = (double)dDays / 365.242199;
        double dMonthsVal = dYearsVal * 12.0;
        long dMonths = (long)dMonthsVal;
        if (dMonths < 6L && (dDaysRemainder = (long)((dMonthsVal - (double)dMonths) * 30.4368499)) != 0L) {
            return DateHelper.durationToString(dMonths, "month") + " and " + DateHelper.durationToString(dDaysRemainder, "day");
        }
        if (dMonths < 24L) {
            return DateHelper.durationToString(dMonths, "month");
        }
        long dYears = (long)dYearsVal;
        long dMonthsRemainder = dMonths % 12L;
        if (dMonthsRemainder == 0L) {
            return DateHelper.durationToString(dYears, "year");
        }
        return DateHelper.durationToString(dYears, "year") + " and " + DateHelper.durationToString(dMonthsRemainder, "month");
    }

    private static String durationToString(long dur, String unit) {
        if (dur == 1L) {
            return dur + " " + unit;
        }
        return dur + " " + unit + "s";
    }

    public static String fuzzyDate(long birthMs, long nowMs, TimeZone tz, Locale locale) {
        long elapsed = Math.abs(nowMs - birthMs);
        Date birth = new Date(birthMs);
        Date now = new Date(nowMs);
        Relation nowBirthRelation = DateHelper.getDayRelation(now, birth, tz);
        if (birth.after(now)) {
            if (elapsed < 3600000L) {
                return "in " + DateHelper.fuzzyAge(nowMs, birthMs, tz, locale);
            }
            if (nowBirthRelation == Relation.TODAY) {
                return "at " + DateHelper.newTimeFormat(3, tz, locale).format(birth.getTime());
            }
            if (nowBirthRelation == Relation.TOMORROW) {
                return "at " + DateHelper.newTimeFormat(3, tz, locale).format(birth.getTime()) + " tomorrow";
            }
            return DateHelper.fuzzyDayName(birthMs, nowMs, tz, locale);
        }
        if (elapsed < 60000L) {
            return "a moment ago";
        }
        if (elapsed < 600000L) {
            return "just now";
        }
        if (nowBirthRelation == Relation.TODAY) {
            return DateHelper.newTimeFormat(3, tz, locale).format(birth.getTime());
        }
        if (nowBirthRelation == Relation.YESTERDAY) {
            return DateHelper.newTimeFormat(3, tz, locale).format(birth.getTime()) + " yesterday";
        }
        return DateHelper.fuzzyDayName(birthMs, nowMs, tz, locale);
    }

    public static String fuzzyDayName(long targetDateMs, long nowMs, TimeZone tz, Locale locale) {
        Date now = new Date(nowMs);
        Date targetDate = new Date(targetDateMs);
        Relation nowBirthRelation = DateHelper.getDayRelation(now, targetDate, tz);
        if (nowBirthRelation == Relation.TODAY) {
            return "today";
        }
        if (nowBirthRelation == Relation.TOMORROW) {
            return "tomorrow";
        }
        if (nowBirthRelation == Relation.YESTERDAY) {
            return "yesterday";
        }
        if (targetDate.after(now)) {
            if (DateHelper.withinInterval(6, 6, now.getTime(), targetDate.getTime(), tz)) {
                return DateHelper.newDateFormat("EEEE", tz, locale).format(targetDate);
            }
            if (DateHelper.withinInterval(1, 2, now.getTime(), targetDate.getTime(), tz)) {
                return DateHelper.newDateFormat("MMM d", tz, locale).format(targetDate.getTime());
            }
            if (DateHelper.withinInterval(0, 1, now.getTime(), targetDate.getTime(), tz)) {
                return DateHelper.newDateFormat("MMMM", tz, locale).format(targetDate);
            }
            return DateHelper.newDateFormat("MMM yyyy", tz, locale).format(targetDate);
        }
        if (DateHelper.withinInterval(7, 6, targetDate.getTime(), now.getTime(), tz)) {
            return "last " + DateHelper.newDateFormat("EEEE", tz, locale).format(targetDate);
        }
        if (DateHelper.withinInterval(1, 2, targetDate.getTime(), now.getTime(), tz)) {
            return DateHelper.newDateFormat("MMM d", tz, locale).format(targetDate.getTime());
        }
        if (DateHelper.withinInterval(0, 1, targetDate.getTime(), now.getTime(), tz)) {
            return DateHelper.newDateFormat("MMMM", tz, locale).format(targetDate);
        }
        return DateHelper.newDateFormat("MMM yyyy", tz, locale).format(targetDate);
    }

    public static String fuzzyAge(long birthMs, long nowMs, TimeZone tz, Locale locale) {
        String plural;
        String singular;
        int number;
        Date latestDate;
        Date earliestDate;
        long age;
        Date birth = new Date(birthMs);
        Date now = new Date(nowMs);
        Relation nowBirthRelation = DateHelper.getDayRelation(now, birth, tz);
        if (birth.after(now)) {
            age = birth.getTime() - now.getTime();
            earliestDate = now;
            latestDate = birth;
        } else {
            age = now.getTime() - birth.getTime();
            earliestDate = birth;
            latestDate = now;
        }
        if (age < 60000L) {
            return "a few seconds";
        }
        if (age < 600000L) {
            return "a few minutes";
        }
        if (age < 3600000L) {
            number = (int)Math.floor(age / 60000L);
            singular = "min";
            plural = "mins";
        } else if (nowBirthRelation == Relation.TODAY || nowBirthRelation == Relation.YESTERDAY || nowBirthRelation == Relation.TOMORROW) {
            number = (int)Math.floor(age / 1000L / 60L / 60L);
            singular = "hour";
            plural = "hours";
        } else if (DateHelper.withinInterval(13, 6, earliestDate.getTime(), latestDate.getTime(), tz)) {
            number = (int)Math.floor(age / 1000L / 60L / 60L / 24L);
            singular = "day";
            plural = "days";
        } else if (DateHelper.withinInterval(2, 2, earliestDate.getTime(), latestDate.getTime(), tz)) {
            number = (int)Math.floor(age / 1000L / 60L / 60L / 24L / 7L);
            singular = "week";
            plural = "weeks";
        } else if (DateHelper.withinInterval(2, 1, earliestDate.getTime(), latestDate.getTime(), tz)) {
            number = (int)Math.floor((double)(age / 1000L / 60L / 60L / 24L) / 30.4);
            singular = "month";
            plural = "months";
        } else {
            number = (int)Math.floor((double)(age / 1000L / 60L / 60L / 24L) / 365.3);
            singular = "year";
            plural = "years";
        }
        return number + " " + ExpressionUtil.pluralise(singular, plural, number);
    }

    public static String fuzzyTime(Date birth, Date now, TimeZone timeZone, Locale locale) {
        return DateHelper.fuzzyTime(birth, now, timeZone, locale, "h:mm a");
    }

    public static String fuzzyTime(Date birth, Date now, TimeZone timeZone, Locale locale, String nonfuzzyFormat) {
        long age = now.getTime() - birth.getTime();
        if (age >= 0L && age < 60000L) {
            return "1 min ago";
        }
        if (DateHelper.getDayRelation(now, birth, timeZone) == Relation.TODAY) {
            String plural;
            String singular;
            int number;
            if (age < 3600000L) {
                number = (int)Math.floor(age / 1000L / 60L);
                singular = "min";
                plural = "mins";
            } else {
                number = (int)Math.floor(age / 1000L / 60L / 60L);
                singular = "hr";
                plural = "hrs";
            }
            return number + " " + ExpressionUtil.pluralise(singular, plural, number) + " ago";
        }
        return DateHelper.newDateFormat(nonfuzzyFormat, timeZone, locale).format(birth).toLowerCase(Locale.US);
    }

    public static boolean withinInterval(int n2, int calendarField, long timeA, long timeB, TimeZone tz) {
        if (timeA > timeB) {
            return DateHelper.withinInterval(n2, calendarField, timeB, timeA, tz);
        }
        Locale locale = Locale.US;
        GregorianCalendar a2 = new GregorianCalendar(tz, locale);
        a2.setTimeInMillis(timeA);
        GregorianCalendar b2 = new GregorianCalendar(tz, locale);
        b2.setTimeInMillis(timeB);
        DateHelper.roundDownToNearest(b2, calendarField);
        b2.add(calendarField, -n2);
        return a2.getTimeInMillis() >= b2.getTimeInMillis();
    }

    public static void roundDownToNearest(Calendar cal, int calendarField) {
        switch (calendarField) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                switch (calendarField) {
                    case 1: {
                        DateHelper.setMinimumValue(cal, 6);
                        break;
                    }
                    case 2: {
                        DateHelper.setMinimumValue(cal, 5);
                        break;
                    }
                    default: {
                        DateHelper.setMinimumValue(cal, 7);
                    }
                }
            }
            case 5: 
            case 6: 
            case 7: {
                DateHelper.setMinimumValue(cal, 11);
            }
            case 10: 
            case 11: {
                DateHelper.setMinimumValue(cal, 12);
            }
            case 12: {
                DateHelper.setMinimumValue(cal, 13);
            }
            case 13: {
                DateHelper.setMinimumValue(cal, 14);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Calendar field: " + calendarField);
            }
        }
    }

    private static void setMinimumValue(Calendar cal, int calendarField) {
        cal.set(calendarField, cal.getActualMinimum(calendarField));
    }

    private static DateFormat newTimeFormat(int style, TimeZone tz, Locale locale) {
        DateFormat df = DateFormat.getTimeInstance(style, locale);
        df.setTimeZone(tz);
        return df;
    }

    private static DateFormat newDateFormat(String pattern, TimeZone tz, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat(pattern, locale);
        df.setTimeZone(tz);
        return df;
    }

    public static int[] timeToComponents(long time) {
        GregorianCalendar date = new GregorianCalendar(GMT);
        date.setTimeInMillis(time);
        int[] components = new int[]{date.get(1), date.get(2) + 1, date.get(5), date.get(11), date.get(12), date.get(13)};
        return components;
    }

    public static long componentsToTime(int[] components) {
        return DateHelper.componentsToTime(components[0], components[1], components[2], components[3], components[4], components[5]);
    }

    public static long componentsToTime(int year, int month, int day, int hour, int min, int sec) {
        return DateHelper.componentsToTime(year, month, day, hour, min, sec, GMT);
    }

    public static long componentsToTime(int year, int month, int day, int hour, int min, int sec, TimeZone tz) {
        GregorianCalendar date = new GregorianCalendar(tz);
        date.set(14, 0);
        date.set(year, month - 1, day, hour, min, sec);
        long ms = date.getTimeInMillis();
        return ms / 1000L * 1000L;
    }

    public static Long parseDate(String date, long now, TimeZone tz) {
        Token token;
        if (date == null || date.length() == 0) {
            return null;
        }
        QueryLangLexer lexer = new QueryLangLexer(new StringReader(date));
        lexer.now = now;
        lexer.timezone = tz;
        try {
            token = lexer.nextToken();
        }
        catch (TokenStreamException e2) {
            return null;
        }
        if (token.getType() != 90) {
            return null;
        }
        QueryLangLexer.DateToken dt = (QueryLangLexer.DateToken)token;
        return dt.date;
    }

    public static Calendar timeAsCalendar(long date, TimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.setTimeInMillis(date);
        return cal;
    }

    public static Date getEndOfDay(Date day, TimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.setTime(day);
        cal.set(11, cal.getMaximum(11));
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        return cal.getTime();
    }

    public static Date getStartOfDay(Date day, TimeZone tz) {
        return DateHelper.getStartOfDayAsCalendar(day, tz).getTime();
    }

    public static Calendar getStartOfDayAsCalendar(Date day, TimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.setTime(day);
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        return cal;
    }

    public static String toGmtString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(standardGmtDateFormat, Locale.ENGLISH);
        fmt.setTimeZone(GMT);
        return fmt.format(date);
    }

    public static Calendar getStartOfTodayAsCalendar(TimeZone tz) {
        return DateHelper.getStartOfDayAsCalendar(new Date(), tz);
    }

    public static Relation getDayRelation(Date today, Date test, TimeZone tz) {
        Calendar startOfDay = DateHelper.getStartOfDayAsCalendar(today, tz);
        GregorianCalendar startOfYesterday = new GregorianCalendar(tz);
        startOfYesterday.setTimeInMillis(startOfDay.getTimeInMillis());
        startOfYesterday.add(5, -1);
        GregorianCalendar startOfTomorrow = new GregorianCalendar(tz);
        startOfTomorrow.setTimeInMillis(startOfDay.getTimeInMillis());
        startOfTomorrow.add(5, 1);
        GregorianCalendar startOfDayAfterTomorrow = new GregorianCalendar(tz);
        startOfDayAfterTomorrow.setTimeInMillis(startOfTomorrow.getTimeInMillis());
        startOfDayAfterTomorrow.add(5, 1);
        Relation relation = Relation.NEITHER;
        if (test.getTime() >= startOfDay.getTimeInMillis() && test.getTime() < startOfTomorrow.getTimeInMillis()) {
            relation = Relation.TODAY;
        } else if (test.getTime() >= startOfYesterday.getTimeInMillis() && test.getTime() < startOfDay.getTimeInMillis()) {
            relation = Relation.YESTERDAY;
        } else if (test.getTime() >= startOfTomorrow.getTimeInMillis() && test.getTime() < startOfDayAfterTomorrow.getTimeInMillis()) {
            relation = Relation.TOMORROW;
        }
        return relation;
    }

    public static boolean sameDateComponent(Date a2, Date b2, int calendarField) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(a2);
        int val = cal.get(calendarField);
        cal.setTime(b2);
        return val == cal.get(calendarField);
    }

    public static Long getDurationMinutes(String text) {
        long minutes = 0L;
        boolean validDurationSeen = false;
        Matcher matcher = DURATION_REGEX.matcher(text.trim().toLowerCase());
        while (matcher.find()) {
            DurationUnit unit;
            long magnitude = Math.round(Double.valueOf(matcher.group(1)));
            DurationUnit durationUnit = unit = Strings.isNullOrEmpty((String)matcher.group(2)) ? DEFAULT_DURATION_UNIT : DurationUnit.fromPrefix(matcher.group(2));
            if (magnitude >= 0L && unit != null) {
                validDurationSeen = true;
                minutes += magnitude * unit.minutes();
                continue;
            }
            return null;
        }
        return validDurationSeen ? Long.valueOf(minutes) : null;
    }

    public static Long getDurationMilliseconds(String text) {
        return DateHelper.getDurationMinutes(text) * 60000L;
    }

    public static String formatDurationMinutes(long minutes) {
        if (minutes <= 0L) {
            return "0" + DEFAULT_DURATION_UNIT.shortFormat();
        }
        ArrayList<String> components = new ArrayList<String>();
        for (DurationUnit unit : DurationUnit.values()) {
            long quotient = Double.valueOf(Math.floor((double)minutes / (double)unit.minutes())).longValue();
            if (quotient > 0L) {
                components.add(String.format("%d%s", quotient, unit.shortFormat()));
            }
            minutes %= unit.minutes();
        }
        return String.join((CharSequence)" ", components);
    }

    public static String formatDurationMilliseconds(long milliseconds) {
        return DateHelper.formatDurationMinutes(milliseconds / 60000L);
    }

    public static boolean isSameDay(Date date1, Date date2, TimeZone tz) {
        return DateHelper.getStartOfDay(date1, tz).equals(DateHelper.getStartOfDay(date2, tz));
    }

    public static boolean isSameDay(TimeZone timeZone, Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance(timeZone);
        c1.setTime(date1);
        Calendar c2 = Calendar.getInstance(timeZone);
        c2.setTime(date2);
        return c1.get(5) == c2.get(5) && c1.get(2) == c2.get(2) && c1.get(1) == c2.get(1);
    }

    public static boolean isSameYear(TimeZone timeZone, Date date1, Date date2) {
        return DateHelper.isSameYear(date1, date2, timeZone);
    }

    public static boolean isSameYear(Date date1, Date date2, TimeZone tz) {
        Calendar c1 = Calendar.getInstance(tz);
        c1.setTime(date1);
        Calendar c2 = Calendar.getInstance(tz);
        c2.setTime(date2);
        return c1.get(1) == c2.get(1);
    }

    public static Date getNearestHalfHour(Date input) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(input);
        int minute = calendar.get(12);
        if (minute >= 45) {
            calendar.add(10, 1);
            minute = 0;
        } else {
            minute = minute >= 15 ? 30 : 0;
        }
        calendar.set(12, minute);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static enum DurationUnit {
        HOUR("hour", "h", 60L),
        MINUTE("minute", "m", 1L);

        private String name;
        private long minutes;
        private String shortFormat;

        private DurationUnit(String name, String shortFormat, long minutes) {
            this.name = name;
            this.minutes = minutes;
            this.shortFormat = shortFormat;
        }

        public long minutes() {
            return this.minutes;
        }

        public String shortFormat() {
            return this.shortFormat;
        }

        public static DurationUnit fromPrefix(String prefix) {
            if (prefix.length() > 0) {
                for (DurationUnit unit : DurationUnit.values()) {
                    String plural = unit.name + "s";
                    if (!plural.startsWith(prefix)) continue;
                    return unit;
                }
            }
            return null;
        }
    }

    public static enum Relation {
        TODAY,
        YESTERDAY,
        TOMORROW,
        NEITHER;

    }
}

