/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.FileNameMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class CustomFileNameMap
implements FileNameMap {
    private final Map<String, String> mimeMap = new HashMap<String, String>();
    private final Set<String> textTypes = new HashSet<String>();
    private final boolean noExtensionIsText;

    public CustomFileNameMap(boolean noExtensionIsText) {
        this.noExtensionIsText = noExtensionIsText;
    }

    public void loadConfig(File ... directories) {
        for (File directory : directories) {
            this.loadMimeMap(new File(directory, "raw-mime.types"), false);
            this.loadMimeMap(new File(directory, "text-mime.types"), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMimeMap(File mapFile, boolean textMap) {
        if (!mapFile.isFile()) {
            return;
        }
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(mapFile));
            while ((line = in.readLine()) != null) {
                String mimeType;
                if ((line = line.trim()).startsWith("#") || line.length() == 0 || (mimeType = this.parseLine(line)) == null || !textMap) continue;
                this.addTextMimeType(mimeType);
            }
        }
        catch (IOException e2) {
            try {
                Logs.APP_LOG.warn((Object)("Error reading mime type mapping from " + mapFile), (Throwable)e2);
            }
            catch (Throwable throwable) {
                IOHelper.close(in);
                throw throwable;
            }
            IOHelper.close(in);
        }
        IOHelper.close(in);
    }

    private String parseLine(String line) {
        StringTokenizer tok = new StringTokenizer(line);
        String mimetype = null;
        if (tok.hasMoreTokens()) {
            mimetype = tok.nextToken();
            while (tok.hasMoreTokens()) {
                String ext = tok.nextToken();
                this.addExtensionMapping(mimetype, ext);
            }
        } else {
            Logs.APP_LOG.warn((Object)("not a valid line in mime type file:" + line));
        }
        return mimetype;
    }

    public void addTextMimeType(String mimeType) {
        this.textTypes.add(mimeType);
    }

    public void addExtensionMapping(String mimeType, String extension) {
        this.mimeMap.put(extension, mimeType);
    }

    @Override
    public String getContentTypeFor(String fileName) {
        if (fileName == null) {
            return null;
        }
        int idx = fileName.lastIndexOf(46);
        if (fileName.length() == idx + 1) {
            return null;
        }
        String ext = fileName.substring(idx + 1);
        return this.mimeMap.get(ext);
    }

    public boolean isTextType(String fileName) {
        return this.isTextType(fileName, false);
    }

    private boolean isTextType(String fileName, boolean defaultToText) {
        String mimeType = this.getContentTypeFor(fileName);
        boolean isText = defaultToText;
        if (mimeType != null) {
            isText = this.isTextMimeType(mimeType);
        } else if (!fileName.contains(".")) {
            isText = this.noExtensionIsText;
        }
        return isText;
    }

    public boolean isBinaryType(String filename) {
        return !this.isTextType(filename);
    }

    public boolean isBinaryType(String filename, boolean defaultToText) {
        return !this.isTextType(filename, defaultToText);
    }

    public boolean isTextMimeType(String mimeType) {
        return mimeType != null && (mimeType.startsWith("text/") || this.textTypes.contains(mimeType));
    }

    public boolean isBinaryMimeType(String mimeType) {
        return !this.isTextMimeType(mimeType);
    }
}

