/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.StringUtil;
import java.io.IOException;
import java.io.Writer;

public class CsvWriter {
    private final Writer out;
    private static final String NL = "\r\n";
    private boolean isFirstCol = true;

    public CsvWriter(Writer out) {
        this.out = out;
    }

    public void endHeader() throws IOException {
        this.endRow();
    }

    public void writeHeaderColumn(String name) throws IOException {
        this.writeString(name);
    }

    public void writeString(String s2) throws IOException {
        this.writeSep();
        if (s2 == null || s2.length() == 0) {
            return;
        }
        this.out.write('\"' + CsvWriter.formatString(s2) + '\"');
    }

    public void writeStringArray(String[] tags) throws IOException {
        this.writeSep();
        this.out.write(34);
        this.out.write(CsvWriter.formatString(String.join((CharSequence)", ", tags)));
        this.out.write(34);
    }

    private static String formatString(String s2) {
        char quote = '\"';
        return s2.replaceAll(quote + "", "" + quote + quote + "");
    }

    public void writeInt(Integer i2) throws IOException {
        this.writeSep();
        if (i2 == null) {
            return;
        }
        this.out.write(i2.toString());
    }

    public void writeDate(long date) throws IOException {
        this.writeSep();
        int[] vals = DateHelper.timeToComponents(date);
        StringBuffer buf = new StringBuffer(20);
        StringUtil.pad(buf, vals[0], 2).append("/");
        StringUtil.pad(buf, vals[1], 2).append("/");
        StringUtil.pad(buf, vals[2], 2).append(" ");
        StringUtil.pad(buf, vals[3], 2).append(":");
        StringUtil.pad(buf, vals[4], 2).append(":");
        StringUtil.pad(buf, vals[5], 2);
        this.out.write(buf.toString());
    }

    private void writeSep() throws IOException {
        if (!this.isFirstCol) {
            this.out.write(",");
        }
        this.isFirstCol = false;
    }

    public void endRow() throws IOException {
        this.out.write(NL);
        this.isFirstCol = true;
    }
}

