/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ConfigurableThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final boolean daemon;

    public ConfigurableThreadFactory(String namePrefix, boolean daemon) {
        SecurityManager s2 = System.getSecurityManager();
        this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = namePrefix;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r2) {
        Thread t2 = new Thread(this.group, r2, this.namePrefix + this.threadNumber.getAndIncrement());
        t2.setDaemon(this.daemon);
        if (t2.getPriority() != 5) {
            t2.setPriority(5);
        }
        return t2;
    }
}

