/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

public class ColourScaler {
    private static final int MAX = 256;
    private int mStartR;
    private int mStartG;
    private int mStartB;
    private int mEndR;
    private int mEndG;
    private int mEndB;
    private int mPosition;

    public void setStartColour(String c2) {
        this.mStartR = Integer.parseInt(c2.substring(0, 2), 16);
        this.mStartG = Integer.parseInt(c2.substring(2, 4), 16);
        this.mStartB = Integer.parseInt(c2.substring(4, 6), 16);
    }

    public void setEndColour(String c2) {
        this.mEndR = Integer.parseInt(c2.substring(0, 2), 16);
        this.mEndG = Integer.parseInt(c2.substring(2, 4), 16);
        this.mEndB = Integer.parseInt(c2.substring(4, 6), 16);
    }

    public void setPosition(int position) {
        position = Math.min(position, 256);
        this.mPosition = position = Math.max(position, 0);
    }

    public String getScaledReverseColour() {
        int r2 = ColourScaler.scale(this.mPosition, this.mStartR, this.mEndR);
        int g2 = ColourScaler.scale(this.mPosition, this.mStartG, this.mEndG);
        int b2 = ColourScaler.scale(this.mPosition, this.mStartB, this.mEndB);
        int avg = (r2 + g2 + b2) / 3;
        int thresh = 180;
        if (avg > 180) {
            return "#000";
        }
        return "#fff";
    }

    public String getScaledColour() {
        StringBuffer buf = new StringBuffer(7);
        buf.append('#');
        ColourScaler.addHexValue(buf, ColourScaler.scale(this.mPosition, this.mStartR, this.mEndR));
        ColourScaler.addHexValue(buf, ColourScaler.scale(this.mPosition, this.mStartG, this.mEndG));
        ColourScaler.addHexValue(buf, ColourScaler.scale(this.mPosition, this.mStartB, this.mEndB));
        return buf.toString();
    }

    private static void addHexValue(StringBuffer buf, int i2) {
        String s2 = Integer.toHexString(i2);
        if (s2.length() <= 1) {
            buf.append('0');
        }
        buf.append(s2);
    }

    private static int scale(int position, int start, int end) {
        int width = end - start;
        return position * width / 256 + start;
    }
}

