/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;

public class CollectionsUtil {
    public static <T> Set<T> asSet(Collection<T> list) {
        if (list == null) {
            return Collections.emptySet();
        }
        return new HashSet<T>(list);
    }

    public static <T> Set<T> asSet(T ... array) {
        return CollectionsUtil.asSet(Arrays.asList(array));
    }

    public static <T> List<T> asList(Collection<T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(collection);
    }

    public static <T> Set<T> mergeSet(Set<T> first, Set<T> second) {
        HashSet<T> s2 = new HashSet<T>(first.size() + second.size());
        s2.addAll(first);
        s2.addAll(second);
        return s2;
    }

    public static boolean anyHasNext(Iterator<?> ... iterators) {
        for (Iterator<?> i2 : iterators) {
            if (i2 == null || !i2.hasNext()) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> truncate(List<T> orig, int maxSize) {
        if (orig.size() <= maxSize) {
            return orig;
        }
        return orig.subList(0, maxSize);
    }

    public static <T> int findSublist(List<T> list, List<T> sublist) {
        if (sublist != null && list != null && list.size() >= sublist.size()) {
            if (sublist.isEmpty()) {
                return 0;
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                T item;
                int j2 = 0;
                for (int s2 = i2; j2 < sublist.size() && s2 < list.size() && ObjectUtils.equals(item = list.get(s2), sublist.get(j2)); ++j2, ++s2) {
                }
                if (j2 != sublist.size()) continue;
                return i2;
            }
        }
        return -1;
    }
}

