/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class AntGlob {
    public static final String STAR_STAR = "**";
    private static final Pattern SPLIT_PATTERN = Pattern.compile("/");
    private final List<String> patDirs;
    private final String mPatternString;
    private boolean mCaseSensitiveDefault;

    public AntGlob(String pattern) {
        this(pattern, false);
    }

    public AntGlob(String pattern, boolean isCaseSensitive) {
        this.mCaseSensitiveDefault = isCaseSensitive;
        this.mPatternString = pattern = pattern.replace('\\', '/');
        this.patDirs = Lists.newArrayList();
        if (!pattern.startsWith("/")) {
            this.patDirs.add(STAR_STAR);
        }
        AntGlob.split(pattern, this.patDirs);
        if (pattern.endsWith("/")) {
            this.patDirs.add(STAR_STAR);
        }
    }

    public String pattern() {
        return this.mPatternString;
    }

    public boolean matches(CharSequence path) {
        return this.matchPath(path, this.mCaseSensitiveDefault);
    }

    public boolean matches(CharSequence path, boolean isCaseSensitive) {
        return this.matchPath(path, isCaseSensitive);
    }

    private boolean matchPath(CharSequence str, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        ArrayList strDirs = Lists.newArrayList();
        AntGlob.split(str, strDirs);
        int patIdxStart = 0;
        int patIdxEnd = this.patDirs.size() - 1;
        int strIdxEnd = strDirs.size() - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = this.patDirs.get(patIdxStart)).equals(STAR_STAR); ++patIdxStart, ++strIdxStart) {
            if (AntGlob.match(patDir, (CharSequence)strDirs.get(strIdxStart), isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (this.patDirs.get(i2).equals(STAR_STAR)) continue;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = this.patDirs.get(patIdxEnd)).equals(STAR_STAR)) {
            if (!AntGlob.match(patDir, (CharSequence)strDirs.get(strIdxEnd), isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (this.patDirs.get(i3).equals(STAR_STAR)) continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i4 = patIdxStart + 1; i4 <= patIdxEnd; ++i4) {
                if (!this.patDirs.get(i4).equals(STAR_STAR)) continue;
                patIdxTmp = i4;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i5 = 0; i5 <= strLength - patLength; ++i5) {
                for (int j2 = 0; j2 < patLength; ++j2) {
                    CharSequence subStr;
                    String subPat = this.patDirs.get(patIdxStart + j2 + 1);
                    if (!AntGlob.match(subPat, subStr = (CharSequence)strDirs.get(strIdxStart + i5 + j2), isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i5;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i6 = patIdxStart; i6 <= patIdxEnd; ++i6) {
            if (this.patDirs.get(i6).equals(STAR_STAR)) continue;
            return false;
        }
        return true;
    }

    public static boolean match(String pattern, CharSequence str, boolean isCaseSensitive) {
        char ch;
        char[] patArr = pattern.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = str.length() - 1;
        boolean containsStar = false;
        for (char aPatArr : patArr) {
            if (aPatArr != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i2 = 0; i2 <= patIdxEnd; ++i2) {
                char ch2 = patArr[i2];
                if (ch2 == '?') continue;
                if (isCaseSensitive && ch2 != str.charAt(i2)) {
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(str.charAt(i2))) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != str.charAt(strIdxStart)) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(str.charAt(strIdxStart))) {
                    return false;
                }
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (patArr[i3] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != str.charAt(strIdxEnd)) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(str.charAt(strIdxEnd))) {
                    return false;
                }
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i4 = patIdxStart; i4 <= patIdxEnd; ++i4) {
                if (patArr[i4] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i5 = patIdxStart + 1; i5 <= patIdxEnd; ++i5) {
                if (patArr[i5] != '*') continue;
                patIdxTmp = i5;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i6 = 0; i6 <= strLength - patLength; ++i6) {
                for (int j2 = 0; j2 < patLength; ++j2) {
                    ch = patArr[patIdxStart + j2 + 1];
                    if (ch != '?' && (isCaseSensitive && ch != str.charAt(strIdxStart + i6 + j2) || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(str.charAt(strIdxStart + i6 + j2)))) continue block8;
                }
                foundIdx = strIdxStart + i6;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i7 = patIdxStart; i7 <= patIdxEnd; ++i7) {
            if (patArr[i7] == '*') continue;
            return false;
        }
        return true;
    }

    private static void split(CharSequence path, List<String> dest) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.subSequence(1, path.length());
        }
        String[] parts = SPLIT_PATTERN.split(path);
        dest.addAll(Arrays.asList(parts));
    }

    public static boolean containsPathSeperator(String s2) {
        return s2.indexOf(47) != -1 || s2.indexOf(92) != -1;
    }

    public static boolean containsExplicitWildcards(String s2) {
        return s2.indexOf(42) != -1 || s2.indexOf(63) != -1;
    }

    public static boolean containsExplicitOrImplicitWildcards(String s2) {
        return AntGlob.containsExplicitWildcards(s2) || !s2.startsWith("/") || s2.endsWith("/");
    }

    public static boolean isExactPrefixMatcher(String s2) {
        if (s2.startsWith("/") && (s2.endsWith("/") || s2.endsWith("/**"))) {
            int beforeTail = s2.lastIndexOf(47) - 1;
            return s2.lastIndexOf(42, beforeTail) == -1 && s2.lastIndexOf(63, beforeTail) == -1;
        }
        return false;
    }

    public static String trimTrailingAsterisks(String s2) {
        int firstAsterisk = s2.indexOf(42);
        return firstAsterisk == -1 ? s2 : s2.substring(0, firstAsterisk);
    }

    public String toString() {
        return "AntGlob<" + this.mPatternString + ",cs=" + this.mCaseSensitiveDefault + ">";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AntGlob antGlob = (AntGlob)o2;
        if (this.mCaseSensitiveDefault != antGlob.mCaseSensitiveDefault) {
            return false;
        }
        return this.patDirs.equals(antGlob.patDirs);
    }

    public int hashCode() {
        int result = this.patDirs.hashCode();
        result = 29 * result + (this.mCaseSensitiveDefault ? 1 : 0);
        return result;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.mCaseSensitiveDefault = caseSensitive;
    }
}

