/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

public class AgeLogScale {
    private final long min;
    private final long max;
    private static final int FUDGE_FACTOR = 10000;

    public AgeLogScale(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public long dateOfIndex(int i2, int total) {
        if (i2 < 0 || i2 > total) {
            throw new IllegalArgumentException("Cannot scale value " + i2 + " outside of of range " + total);
        }
        double z2 = this.log(i2) / this.log(total);
        return (long)((double)this.min + (double)(this.max - this.min) * z2);
    }

    public int indexOfDate(long d2, int low, int high) {
        float z2 = (float)(d2 - this.min) / (float)(this.max - this.min + 1L);
        return (int)(Math.pow(z2, Math.E) * (double)(high - low) + (double)low);
    }

    private double log(double x2) {
        return Math.log1p(10000.0 * x2);
    }
}

