/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd.sso.cookie;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.CrowdClient;
import com.cenqua.crucible.hibernate.WithSession;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.embeddedcrowd.sso.cookie.CookieConfigurationService;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="cookieConfigurationService")
@Lazy
public class CachedCookieConfigurationService
implements CookieConfigurationService {
    private static final long COOKIE_CONFIGURATION_CACHE_TIMEOUT_SEC = 60L;
    private static final Logger log = Logs.loggerFor(CachedCookieConfigurationService.class);
    private final CrowdDirectoryService crowdDirectoryService;
    private final RestCrowdClientFactory restClientFactory;
    private final LoadingCache<Long, CookieConfiguration> cookieConfigurationByDirectoryId;

    @Autowired
    public CachedCookieConfigurationService(CrowdDirectoryService crowdDirectoryService, RestCrowdClientFactory restClientFactory) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.restClientFactory = restClientFactory;
        this.cookieConfigurationByDirectoryId = this.createCookieConfigurationCache();
    }

    private LoadingCache<Long, CookieConfiguration> createCookieConfigurationCache() {
        return CacheBuilder.newBuilder().maximumSize(100L).refreshAfterWrite(60L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Long, CookieConfiguration>(){

            private CookieConfiguration getCookieConfiguration(Long directoryId, @Nullable CookieConfiguration previousCookieConfiguration) throws OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
                Directory directory = CachedCookieConfigurationService.this.crowdDirectoryService.findDirectoryById(directoryId.longValue());
                Preconditions.checkArgument((directory.getType() == DirectoryType.CROWD ? 1 : 0) != 0, (String)"Directory (id: %s, name: %s) is not a CROWD type directory", (Object[])new Object[]{directoryId, directory.getName()});
                CrowdClient crowdClient = CachedCookieConfigurationService.this.createCrowdClientForDirectory(directory);
                CookieConfiguration newCookieConfiguration = crowdClient.getCookieConfiguration();
                String newCookieConfigurationName = Strings.nullToEmpty((String)newCookieConfiguration.getName());
                String newCookieConfigurationDomain = Strings.nullToEmpty((String)newCookieConfiguration.getDomain());
                if (previousCookieConfiguration == null) {
                    log.info((Object)String.format("[Crowd SSO] Received cookie configuration (cookie name: %s, domain: %s) for directory: %s.", newCookieConfigurationName, newCookieConfigurationDomain, directory.getName()));
                } else {
                    String previousCookieConfigurationName = Strings.nullToEmpty((String)previousCookieConfiguration.getName());
                    String previousCookieConfigurationDomain = Strings.nullToEmpty((String)previousCookieConfiguration.getDomain());
                    if (!newCookieConfigurationName.equals(previousCookieConfigurationName)) {
                        log.info((Object)String.format("[Crowd SSO] Updating cookie configuration for directory: %s. Cookie name changed from: %s to %s.", directory.getName(), previousCookieConfigurationName, newCookieConfigurationName));
                    }
                    if (!newCookieConfigurationDomain.equals(previousCookieConfigurationDomain)) {
                        log.info((Object)String.format("[Crowd SSO] Updating cookie configuration for directory: %s. Domain changed from: %s to %s.", directory.getName(), previousCookieConfigurationDomain, newCookieConfigurationDomain));
                    }
                }
                return newCookieConfiguration;
            }

            public CookieConfiguration load(Long directoryId) throws OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
                return this.getCookieConfiguration(directoryId, null);
            }

            public ListenableFuture<CookieConfiguration> reload(Long directoryId, CookieConfiguration previousCookieConfiguration) throws OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
                return Futures.immediateFuture((Object)this.getCookieConfiguration(directoryId, previousCookieConfiguration));
            }
        });
    }

    @Override
    @WithSession
    public CookieConfiguration getCookieConfigurationForDirectory(Directory directory) throws OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
        try {
            return (CookieConfiguration)this.cookieConfigurationByDirectoryId.get((Object)directory.getId());
        }
        catch (UncheckedExecutionException | ExecutionException e2) {
            Throwables.propagateIfPossible((Throwable)e2.getCause(), OperationFailedException.class);
            Throwables.propagateIfPossible((Throwable)e2.getCause(), ApplicationPermissionException.class);
            Throwables.propagateIfPossible((Throwable)e2.getCause(), InvalidAuthenticationException.class);
            Throwables.propagateIfPossible((Throwable)e2.getCause(), RuntimeException.class);
            throw Throwables.propagate((Throwable)e2.getCause());
        }
    }

    private CrowdClient createCrowdClientForDirectory(Directory directory) {
        ClientProperties clientProperties = this.createClientProperties(directory);
        return this.restClientFactory.newInstance(clientProperties);
    }

    private ClientProperties createClientProperties(Directory directory) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)directory.getAttributes());
        return ClientPropertiesImpl.newInstanceFromProperties((Properties)props);
    }
}

