/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd.sso.configuration;

import com.cenqua.crucible.hibernate.WithSession;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.CrowdAuthConfigType;
import com.cenqua.fisheye.user.embeddedcrowd.sso.configuration.SSOConfigurationService;
import java.util.Optional;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="ssoConfigurationService")
@Lazy
public class RootConfigSSOConfigurationService
implements SSOConfigurationService {
    public static final String DEFAULT_CROWD_SESSIONKEY_VALIDATIONINTERVAL_MIN = "2";
    public static final String DEFAULT_CROWD_HTTP_TIMEOUT = "5000";
    public static final String DEFAULT_CROWD_SOCKET_TIMEOUT = "20000";
    public static final boolean DEFAULT_IS_SSO_ENABLED = false;
    private final RootConfig rootConfig;

    @Autowired
    public RootConfigSSOConfigurationService(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
    }

    private Optional<CrowdAuthConfigType> crowdAuthConfig() {
        if (this.rootConfig.getConfig().isSetSecurity() && this.rootConfig.getConfig().getSecurity().isSetCrowd()) {
            return Optional.of(this.rootConfig.getConfig().getSecurity().getCrowd());
        }
        return Optional.empty();
    }

    @Override
    @WithSession
    public boolean isSSOEnabled() {
        return this.crowdAuthConfig().map(CrowdAuthConfigType::getSsoEnabled).orElse(false);
    }

    @Override
    public Properties getCrowdProperties() {
        Properties properties = new Properties();
        properties.setProperty("session.validationinterval", DEFAULT_CROWD_SESSIONKEY_VALIDATIONINTERVAL_MIN);
        properties.setProperty("http.timeout", DEFAULT_CROWD_HTTP_TIMEOUT);
        properties.setProperty("socket.timeout", DEFAULT_CROWD_SOCKET_TIMEOUT);
        properties.setProperty("cookie.tokenkey", "crowd.token_key");
        properties.setProperty("session.lastvalidation", "fisheye.crowd.session.lastvalidation");
        return properties;
    }
}

