/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd.sso.authenticator;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticatorImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelperImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractorImpl;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.CrowdClient;
import com.cenqua.crucible.hibernate.WithSession;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.embeddedcrowd.sso.authenticator.AuthenticatorFactoryService;
import com.cenqua.fisheye.user.embeddedcrowd.sso.configuration.SSOConfigurationService;
import com.cenqua.fisheye.user.embeddedcrowd.sso.cookie.CookieConfigurationService;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="authenticatorFactoryService")
@Lazy
public class DefaultAuthenticatorFactoryService
implements AuthenticatorFactoryService {
    private static final Logger log = Logs.loggerFor(DefaultAuthenticatorFactoryService.class);
    private final RestCrowdClientFactory restCrowdClientFactory;
    private final SSOConfigurationService ssoConfigurationService;
    private final CookieConfigurationService cookieConfigurationService;
    private final CrowdHttpTokenHelper tokenHelper;

    @Autowired
    public DefaultAuthenticatorFactoryService(RestCrowdClientFactory restCrowdClientFactory, SSOConfigurationService ssoConfigurationService, CookieConfigurationService cookieConfigurationService) {
        this.restCrowdClientFactory = restCrowdClientFactory;
        this.ssoConfigurationService = ssoConfigurationService;
        this.cookieConfigurationService = cookieConfigurationService;
        this.tokenHelper = CrowdHttpTokenHelperImpl.getInstance((CrowdHttpValidationFactorExtractor)CrowdHttpValidationFactorExtractorImpl.getInstance());
    }

    @Override
    @WithSession
    public CrowdHttpAuthenticator createAuthenticatorForDirectory(Directory directory) {
        ClientProperties clientProperties = this.createClientPropertiesWithCookieConfiguration(directory);
        CrowdClient crowdClient = this.restCrowdClientFactory.newInstance(clientProperties);
        return new CrowdHttpAuthenticatorImpl(crowdClient, clientProperties, this.tokenHelper);
    }

    private ClientProperties createClientPropertiesWithCookieConfiguration(Directory directory) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.ssoConfigurationService.getCrowdProperties());
        properties.putAll((Map<?, ?>)directory.getAttributes());
        try {
            CookieConfiguration cookieConfiguration = this.cookieConfigurationService.getCookieConfigurationForDirectory(directory);
            if (!Strings.isNullOrEmpty((String)cookieConfiguration.getName())) {
                properties.put("cookie.tokenkey", cookieConfiguration.getName());
            }
            if (!Strings.isNullOrEmpty((String)cookieConfiguration.getDomain())) {
                properties.put("cookie.domain", cookieConfiguration.getDomain());
            }
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException | OperationFailedException e2) {
            log.error((Object)String.format("[Crowd SSO] Failed to get cookie configuration for directory: %s. Continuing on defaults. Error: %s", directory.getName(), e2.getMessage()), e2);
        }
        return ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
    }
}

