/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd.sso;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.AuthenticationState;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelperImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractorImpl;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.cenqua.crucible.hibernate.WithSession;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.AuthenticationException;
import com.cenqua.fisheye.user.embeddedcrowd.sso.EmbeddedCrowdSSOService;
import com.cenqua.fisheye.user.embeddedcrowd.sso.authenticator.AuthenticatorFactoryService;
import com.cenqua.fisheye.user.embeddedcrowd.sso.cookie.CookieConfigurationService;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="embeddedCrowdSSOService")
@Lazy
public class DefaultEmbeddedCrowdSSOService
implements EmbeddedCrowdSSOService {
    private static final Logger log = Logs.loggerFor(DefaultEmbeddedCrowdSSOService.class);
    private final CrowdService crowdService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final AuthenticatorFactoryService authenticatorFactoryService;
    private final CookieConfigurationService cookieConfigurationService;
    private final CrowdHttpTokenHelper tokenHelper;

    @Autowired
    public DefaultEmbeddedCrowdSSOService(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, AuthenticatorFactoryService authenticatorFactoryService, CookieConfigurationService cookieConfigurationService) {
        log.debug((Object)("[Crowd SSO] Creating " + DefaultEmbeddedCrowdSSOService.class.getName()));
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.cookieConfigurationService = cookieConfigurationService;
        this.authenticatorFactoryService = authenticatorFactoryService;
        this.tokenHelper = CrowdHttpTokenHelperImpl.getInstance((CrowdHttpValidationFactorExtractor)CrowdHttpValidationFactorExtractorImpl.getInstance());
    }

    private Directory getDirectoryForUser(String username) throws AuthenticationException {
        User crowdUser = this.crowdService.getUser(username);
        if (crowdUser == null) {
            throw new AuthenticationException(String.format("User: %s not found by local CROWD service.", username), new Throwable());
        }
        long directoryId = crowdUser.getDirectoryId();
        return this.crowdDirectoryService.findDirectoryById(directoryId);
    }

    @Override
    @WithSession
    public Optional<User> authenticate(String username, String password, HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        Directory directory = this.getDirectoryForUser(username);
        if (directory.getType() == DirectoryType.CROWD && this.checkDomain(directory, request)) {
            log.debug((Object)String.format("[Crowd SSO] Authenticating user: %s on directory: %s", username, directory.getName()));
            try {
                CrowdHttpAuthenticator authenticator = this.authenticatorFactoryService.createAuthenticatorForDirectory(directory);
                com.atlassian.crowd.model.user.User crowdUserSso = authenticator.authenticate(request, response, username, password);
                return Optional.of((Object)crowdUserSso);
            }
            catch (Exception e2) {
                throw new AuthenticationException((Throwable)e2);
            }
        }
        return Optional.absent();
    }

    @Override
    @WithSession
    public void logout(String username, HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        Directory directory = this.getDirectoryForUser(username);
        if (directory.getType() == DirectoryType.CROWD && this.checkDomain(directory, request)) {
            log.debug((Object)String.format("[Crowd SSO] Logging out user: %s from directory: %s", username, directory.getName()));
            try {
                CrowdHttpAuthenticator authenticator = this.authenticatorFactoryService.createAuthenticatorForDirectory(directory);
                authenticator.logout(request, response);
            }
            catch (Exception e2) {
                throw new AuthenticationException((Throwable)e2);
            }
        }
    }

    @Override
    @WithSession
    public Optional<User> getUserFromToken(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        Set<Directory> potentialSSODirectories = this.findPotentialSSODirectoriesForRequest(request);
        return this.validateRequestAgainstSSODirectories(potentialSSODirectories, request, response);
    }

    private Set<Directory> findPotentialSSODirectoriesForRequest(HttpServletRequest request) {
        Multimap<String, Directory> ssoDirectoriesByTokenName = this.createCrowdDirectoriesByTokeName();
        LinkedHashSet ssoDirectories = Sets.newLinkedHashSet();
        for (String tokenName : ssoDirectoriesByTokenName.keySet()) {
            if (this.tokenHelper.getCrowdToken(request, tokenName) == null) continue;
            ssoDirectories.addAll(ssoDirectoriesByTokenName.get((Object)tokenName));
        }
        return ssoDirectories;
    }

    private Optional<User> validateRequestAgainstSSODirectories(Set<Directory> ssoDirectories, HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        ArrayList exceptions = Lists.newArrayList();
        for (Directory directory : ssoDirectories) {
            if (!this.checkDomain(directory, request)) continue;
            CrowdHttpAuthenticator authenticator = this.authenticatorFactoryService.createAuthenticatorForDirectory(directory);
            try {
                AuthenticationState authenticationState = authenticator.checkAuthenticated(request, response);
                if (!authenticationState.isAuthenticated()) continue;
                String username = (String)authenticationState.getAuthenticatedPrincipal().transform(Principal::getName).or(() -> {
                    try {
                        log.debug((Object)"[Crowd SSO] No principal in authenticationState, where authenticationState.isAuthenticated is true. Making another call: authenticator.getUser");
                        com.atlassian.crowd.model.user.User user = authenticator.getUser(request);
                        return user != null ? user.getName() : null;
                    }
                    catch (Exception e2) {
                        throw Throwables.propagate((Throwable)e2);
                    }
                });
                if (username == null) {
                    log.warn((Object)"[Crowd SSO] token successfully authenticated but could not retrieve user for token from: authenticator.checkAuthenticated.getAuthenticatedPrincipal and authenticator.getUser");
                    return Optional.absent();
                }
                User user = this.crowdService.getUser(username);
                if (user == null) {
                    log.warn((Object)String.format("[Crowd SSO] token successfully authenticated returned a non existing user: %s", username));
                    return Optional.absent();
                }
                return Optional.of((Object)user);
            }
            catch (Exception e2) {
                exceptions.add(e2);
            }
        }
        if (!exceptions.isEmpty() && exceptions.size() == ssoDirectories.size()) {
            throw new AuthenticationException((Throwable)exceptions.iterator().next());
        }
        return Optional.absent();
    }

    private Multimap<String, Directory> createCrowdDirectoriesByTokeName() {
        List<Directory> crowdDirectories = this.getAllCrowdDirectories();
        LinkedHashMultimap crowdDirectoriesByTokeName = LinkedHashMultimap.create();
        for (Directory directory : crowdDirectories) {
            try {
                CookieConfiguration cookieConfiguration = this.cookieConfigurationService.getCookieConfigurationForDirectory(directory);
                if (Strings.isNullOrEmpty((String)cookieConfiguration.getName())) continue;
                crowdDirectoriesByTokeName.put((Object)cookieConfiguration.getName(), (Object)directory);
            }
            catch (ApplicationPermissionException | InvalidAuthenticationException | OperationFailedException e2) {
                log.error((Object)String.format("[Crowd SSO] Error when getting cookie configuration from directory: %s", directory.getName()), e2);
            }
        }
        return crowdDirectoriesByTokeName;
    }

    private List<Directory> getAllCrowdDirectories() {
        return this.crowdDirectoryService.findAllDirectories().stream().filter(directory -> directory.getType() == DirectoryType.CROWD).collect(Collectors.toList());
    }

    @Override
    @WithSession
    public Optional<Boolean> isRequestUserStillValid(String username, HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        Directory directory = this.getDirectoryForUser(username);
        if (directory.getType() == DirectoryType.CROWD && this.checkDomain(directory, request)) {
            log.debug((Object)String.format("[Crowd SSO] Checking if token valid for user: %s from directory: %s", username, directory.getName()));
            try {
                CrowdHttpAuthenticator authenticator = this.authenticatorFactoryService.createAuthenticatorForDirectory(directory);
                return Optional.of((Object)authenticator.checkAuthenticated(request, response).isAuthenticated());
            }
            catch (Exception e2) {
                throw new AuthenticationException((Throwable)e2);
            }
        }
        return Optional.absent();
    }

    private boolean checkDomain(Directory directory, HttpServletRequest request) {
        CookieConfiguration cookieConfiguration;
        try {
            cookieConfiguration = this.cookieConfigurationService.getCookieConfigurationForDirectory(directory);
        }
        catch (ApplicationPermissionException | InvalidAuthenticationException | OperationFailedException e2) {
            log.error((Object)String.format("[Crowd SSO] Could not get domain configuration for directory: %s. Assume domain to configured.", directory.getName()));
            return true;
        }
        if (cookieConfiguration == null) {
            return true;
        }
        String domain = cookieConfiguration.getDomain();
        if (Strings.isNullOrEmpty((String)domain)) {
            return true;
        }
        if (request.getServerName().endsWith(domain)) {
            return true;
        }
        log.debug((Object)String.format("[Crowd SSO] SSO will not be applied to request as the domain: %s is different the configured SSO domain: %s for directory: %s", request.getServerName(), domain, directory.getName()));
        return false;
    }
}

