/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd;

import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.crowd.event.RemoteDirectorySynchronisationCompleteEvent;
import com.atlassian.fecru.user.crowd.event.RemoteDirectorySynchronisationStartedEvent;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.embeddedcrowd.UserSynchronizationStatusManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultUserSynchronizationStatusManager
implements UserSynchronizationStatusManager {
    private static final Logger log = Logs.loggerFor(DefaultUserSynchronizationStatusManager.class);
    private final EventPublisher eventPublisher;
    private final Map<Long, AtomicInteger> syncInProgress = new ConcurrentHashMap<Long, AtomicInteger>();

    @Autowired
    public DefaultUserSynchronizationStatusManager(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onRemoteDirectorySynchronisationStartedEvent(RemoteDirectorySynchronisationStartedEvent event) {
        long directoryId = event.getDirectoryId();
        this.getSyncCount(directoryId).incrementAndGet();
        log.info((Object)("Directory synchronisation started for directory " + directoryId));
    }

    @EventListener
    public void onRemoteDirectorySynchronisedEvent(RemoteDirectorySynchronisedEvent event) {
        long directoryId = event.getDirectoryId();
        this.getSyncCount(directoryId).decrementAndGet();
        log.info((Object)("Directory synchronisation complete for directory " + directoryId));
        this.eventPublisher.publish((Object)new RemoteDirectorySynchronisationCompleteEvent(directoryId));
    }

    @Override
    public boolean isSynchronisationInProgress(long directoryId) {
        return this.getSyncCount(directoryId).get() > 0;
    }

    private AtomicInteger getSyncCount(long directoryId) {
        return this.syncInProgress.computeIfAbsent(directoryId, key -> new AtomicInteger(0));
    }
}

