/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.embeddedcrowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.fecru.user.AuthType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.AuthTok;
import com.cenqua.fisheye.user.AuthenticationException;
import com.cenqua.fisheye.user.BaseAuth;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.embeddedcrowd.EmbeddedCrowdAuth;
import com.cenqua.fisheye.user.embeddedcrowd.EmbeddedCrowdAuthTok;
import com.cenqua.fisheye.user.embeddedcrowd.sso.EmbeddedCrowdSSOService;
import com.cenqua.fisheye.user.embeddedcrowd.sso.configuration.SSOConfigurationService;
import com.google.common.base.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class DefaultEmbeddedCrowdAuth
extends BaseAuth
implements EmbeddedCrowdAuth {
    private static final Logger log = Logs.loggerFor(DefaultEmbeddedCrowdAuth.class);
    private final CrowdService crowdService;
    private final EmbeddedCrowdSSOService embeddedCrowdSSOService;
    private final SSOConfigurationService ssoConfigurationService;

    @Autowired
    public DefaultEmbeddedCrowdAuth(CrowdService crowdService, EmbeddedCrowdSSOService embeddedCrowdSSOService, SSOConfigurationService ssoConfigurationService) {
        super(Logs.APP_LOG);
        this.crowdService = crowdService;
        this.ssoConfigurationService = ssoConfigurationService;
        this.embeddedCrowdSSOService = embeddedCrowdSSOService;
    }

    @Override
    public boolean getAutoAdd() {
        return true;
    }

    @Override
    public EmbeddedCrowdAuthTok authenticate(String username, String password, HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        try {
            User crowdUser = this.crowdService.authenticate(username, password);
            if (this.ssoConfigurationService.isSSOEnabled()) {
                try {
                    Optional<User> ssoUser = this.embeddedCrowdSSOService.authenticate(crowdUser.getName(), password, request, response);
                    if (ssoUser.isPresent()) {
                        log.debug((Object)String.format("[Crowd SSO] Successfully authenticated user: %s", ((User)ssoUser.get()).getName()));
                    }
                    return new EmbeddedCrowdAuthTok(crowdUser, ssoUser.isPresent());
                }
                catch (AuthenticationException e2) {
                    log.warn((Object)"SSO authentication failed. Make sure the remote directory is a Crowd (not JIRA) instance, and the version is supported. ", (Throwable)e2);
                }
            }
            return new EmbeddedCrowdAuthTok(crowdUser, false);
        }
        catch (FailedAuthenticationException e3) {
            return null;
        }
        catch (Exception ex) {
            throw new AuthenticationException((Throwable)ex);
        }
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.EMBEDDED_CROWD;
    }

    @Override
    public AuthTok recreateAuth(String username) throws AuthenticationException {
        User crowdUser = this.crowdService.getUser(username);
        if (crowdUser != null && crowdUser.isActive()) {
            return new EmbeddedCrowdAuthTok(crowdUser, false);
        }
        return null;
    }

    @Override
    public AuthTok getToken(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (!this.ssoConfigurationService.isSSOEnabled()) {
            return null;
        }
        try {
            Optional<User> user = this.embeddedCrowdSSOService.getUserFromToken(request, response);
            if (user.isPresent()) {
                return new EmbeddedCrowdAuthTok((User)user.get(), true);
            }
        }
        catch (AuthenticationException e2) {
            log.warn((Object)"Error verifying SSO request token", (Throwable)e2);
        }
        return null;
    }

    @Override
    public void logout(UserLogin login, HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (!this.isSsoAuthenticatedSession(login)) {
            return;
        }
        this.embeddedCrowdSSOService.logout(login.getUsername(), request, response);
    }

    @Override
    public boolean isRequestUserStillValid(UserLogin user, HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (!this.isSsoAuthenticatedSession(user)) {
            return super.isRequestUserStillValid(user, request, response);
        }
        try {
            return (Boolean)this.embeddedCrowdSSOService.isRequestUserStillValid(user.getUsername(), request, response).or((Object)true);
        }
        catch (AuthenticationException e2) {
            log.warn((Object)"Failed to validate SSO session", (Throwable)e2);
            return false;
        }
    }

    private boolean isSsoAuthenticatedSession(UserLogin user) {
        if (!this.ssoConfigurationService.isSSOEnabled()) {
            return false;
        }
        AuthTok authTok = user.getAuthTok();
        return authTok instanceof EmbeddedCrowdAuthTok && ((EmbeddedCrowdAuthTok)authTok).isSsoAuthenticated();
    }

    @Override
    public boolean isValidPassword(String username, String password) {
        try {
            this.crowdService.authenticate(username, password);
            return true;
        }
        catch (FailedAuthenticationException e2) {
            return false;
        }
    }
}

