/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class UserSearchCriteria
implements Serializable {
    private String name;
    private Collection<String> usernames;
    private String email;
    private Set<GlobalPermissionType> globalUserPermission = Sets.newHashSet();

    private UserSearchCriteria() {
    }

    public static UserSearchCriteria create() {
        return new UserSearchCriteria();
    }

    public UserSearchCriteria all() {
        this.name = null;
        return this;
    }

    public UserSearchCriteria named(String name) {
        this.name = name;
        return this;
    }

    public UserSearchCriteria username(String username) {
        this.usernames = Collections.singleton(username);
        return this;
    }

    public UserSearchCriteria usernames(Collection<String> usernames) {
        this.usernames = usernames;
        return this;
    }

    public String name() {
        return this.name;
    }

    public Collection<String> usernames() {
        return this.usernames;
    }

    public UserSearchCriteria withPermissions(Collection<GlobalPermissionType> globalUserPermission) {
        Preconditions.checkArgument((!globalUserPermission.isEmpty() ? 1 : 0) != 0, (Object)"can't filter by empty permissions");
        this.globalUserPermission.addAll(globalUserPermission);
        return this;
    }

    public UserSearchCriteria withPermissions(GlobalPermissionType globalPermissionType) {
        this.globalUserPermission.add(globalPermissionType);
        return this;
    }

    public Set<GlobalPermissionType> getGlobalUserPermission() {
        return this.globalUserPermission;
    }

    public SearchRestriction toRestriction() {
        ImmutableList.Builder restrictions = ImmutableList.builder();
        if (this.name != null) {
            restrictions.add((Object)new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)this.name), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)this.name), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)this.name)}));
        }
        if (this.usernames != null) {
            restrictions.add((Object)new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, (Collection)this.usernames.stream().map(username -> Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching(username)).collect(Collectors.toList())));
        }
        if (this.email != null) {
            restrictions.add((Object)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)this.email));
        }
        restrictions.add((Object)Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)Boolean.TRUE));
        ImmutableList restrictionsList = restrictions.build();
        if (restrictionsList.isEmpty()) {
            return NullRestrictionImpl.INSTANCE;
        }
        return new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, (Collection)restrictionsList);
    }

    public UserSearchCriteria email(String email) {
        this.email = email;
        return this;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        UserSearchCriteria that = (UserSearchCriteria)o2;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.usernames, that.usernames) && Objects.equal((Object)this.email, (Object)that.email);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.usernames, this.email});
    }
}

