/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.LoginCookieDAO;
import com.atlassian.fecru.user.event.UserRenamedEvent;
import com.cenqua.fisheye.rep.DbException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserRenamer {
    private final LoginCookieDAO loginCookieDAO;
    private final FecruUserDAO userDAO;
    private final EventPublisher eventPublisher;

    @Autowired
    public UserRenamer(LoginCookieDAO loginCookieDAO, FecruUserDAO userDAO, EventPublisher eventPublisher) {
        this.loginCookieDAO = loginCookieDAO;
        this.userDAO = userDAO;
        this.eventPublisher = eventPublisher;
    }

    public void rename(String oldname, String newname) throws DbException {
        if (this.userDAO.existsAny(newname)) {
            throw new IllegalArgumentException("New name " + newname + " already exists");
        }
        FecruUser user = this.userDAO.getByUsername(oldname);
        if (user == null) {
            throw new IllegalArgumentException("Could not find user " + oldname + " to rename.");
        }
        this.loginCookieDAO.deleteCookies(user, 2);
        this.loginCookieDAO.deleteCookies(user, 1);
        this.userDAO.rename(user, newname);
        this.eventPublisher.publish((Object)new UserRenamedEvent(oldname, newname));
    }
}

