/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.Auth;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.user.GroupSearchCriteria;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.LoginCookieToken;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserSearchCriteria;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspContext;

public interface UserManager {
    public static final String USER_ATTR_KEY = "feuser";
    public static final String REMEMBERME_COOKIE_NAME = "remember";
    public static final Pattern USERNAME_PATTERN;
    public static final String USERNAME_PATTERN_DESC = "alphanumeric, underscore, at ('@'), dot, dash or backslash";
    public static final Pattern GROUPNAME_PATTERN;
    public static final String GROUPNAME_PATTERN_DESC = "alphanumeric, underscore, at ('@'), dot, dash or backslash";
    public static final Function<String, String> GROUPNAME_NORMALIZATION;
    public static final Function<String, String> USERNAME_NORMALIZATION;
    public static final String LOGIN_ERROR;

    public void resetFailedLoginAttempts(String var1);

    public void reload(ConfigDocument.Config var1) throws ConfigException;

    public UserLogin validateCurrentUser(HttpServletRequest var1, HttpServletResponse var2);

    public UserLogin getCurrentUser(HttpServletRequest var1);

    public UserLogin getCurrentUser(JspContext var1);

    public LoginCookie preCookUrl(HttpServletRequest var1, String var2, boolean var3);

    public UserLogin login(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4, boolean var5) throws LicensePolicyException;

    public boolean hasUserExceededLoginAttempts(String var1);

    public UserLogin login(HttpServletRequest var1, HttpServletResponse var2, LoginCookieToken var3);

    public UserLogin tryRequestDelegatedLogin(HttpServletRequest var1, HttpServletResponse var2) throws LicensePolicyException;

    public UserLogin createTrustedUserLogin(String var1, boolean var2, boolean var3) throws LicensePolicyException;

    public UserLogin createTrustedUserLogin(String var1) throws LicensePolicyException;

    public void logout(HttpServletRequest var1, HttpServletResponse var2);

    public void logout2(HttpServletRequest var1, HttpServletResponse var2, boolean var3, boolean var4);

    public void logout2User(String var1, boolean var2, boolean var3);

    public String makeSecureRnd();

    public String makeSecureRnd(int var1);

    public List<String> getAllEnabledUsernames();

    public Iterable<String> getAllLicensedUsernames();

    public boolean groupExists(String var1);

    public Optional<GroupInfo> getGroupInfo(String var1);

    public GroupInfo addGroup(String var1);

    public void deleteGroup(String var1);

    @Deprecated
    public List<FecruUser> getLicensedUsers();

    public Page<FecruUser> searchUsers(UserSearchCriteria var1, PageRequest var2);

    public Page<GroupInfo> searchGroups(GroupSearchCriteria var1, PageRequest var2);

    public void renameUser(String var1, String var2);

    public FecruUser addUser(String var1, String var2, String var3, String var4, boolean var5) throws LicensePolicyException;

    public void changePassword(String var1, String var2);

    public void requestPasswordReset(String var1, String var2);

    public void resetPassword(String var1, String var2);

    public boolean canUpdateUser(String var1);

    public void updateUser(String var1, String var2, String var3);

    public boolean existsLicensedUser(String var1);

    public boolean existsEnabledUser(String var1);

    public Optional<FecruUser> getEnabledUser(String var1);

    public GroupInfo ensureGroupExists(String var1) throws NotFoundException;

    public FecruUser getLicensedUser(String var1);

    public FecruUser getLicensedUser(int var1);

    public FecruUser getUser(String var1);

    public FecruUser getUserById(int var1);

    public String getUsernameByEmail(String var1);

    public void deleteUserFully(String var1);

    public boolean deleteUserAndRemoveCommitterMappings(String var1);

    public boolean deleteMultipleUsersAndRemoveCommitterMappings(List<String> var1);

    public void deleteUser(String var1, boolean var2);

    public boolean hasPermissionToAccess(Principal var1, RepositoryHandle var2);

    @Deprecated
    public boolean isCrucibleEnabled(String var1);

    public boolean isLoginPossible();

    public boolean hasSysAdminPrivileges(String var1);

    public boolean hasSysAdminPrivileges(HttpServletRequest var1);

    public FecruUser getUserFor(Principal var1);

    public boolean isValidPassword(String var1, String var2);

    public Auth getAuthenticationProvider();

    public boolean isUserNameValid(String var1);

    public boolean isGroupNameValid(String var1);

    public boolean isAdminGroup(String var1);

    public void setAdminGroup(String var1, boolean var2);

    public boolean isPasswordlessAuthenticationEnabled();

    static {
        GROUPNAME_PATTERN = USERNAME_PATTERN = Pattern.compile("[a-zA-Z0-9\\-_\\.@\\\\]+");
        GROUPNAME_NORMALIZATION = IdentifierUtils::toLowerCase;
        USERNAME_NORMALIZATION = userName -> IdentifierUtils.toLowerCase((String)Strings.nullToEmpty((String)userName).trim());
        LOGIN_ERROR = LoginError.class.getName();
    }

    public static enum LoginError {
        EXCEEDED_MAX_LOGIN_ATTEMPTS,
        FEAUTH_TOKEN_INVALID,
        BASIC_AUTH_INVALID;

    }
}

