/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.fecru.user.AuthType;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.user.AuthTok;
import com.cenqua.fisheye.user.LoginCookie;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Objects;

public class UserLogin
implements Principal,
Serializable,
java.security.Principal {
    private final AuthTok authTok;
    private final LoginCookie cookie;
    private String displayName;
    private final String username;

    public UserLogin(FecruUser feuser, AuthTok authTok, LoginCookie cookie) {
        this.username = feuser.getUsername();
        this.authTok = authTok;
        this.cookie = cookie;
        this.displayName = feuser.getDisplayName();
    }

    @Override
    public String getName() {
        return this.getUsername();
    }

    public final String getUserName() {
        return this.getUsername();
    }

    public String getUsername() {
        return this.username;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public AuthTok getAuthTok() {
        return this.authTok;
    }

    public LoginCookie getCookie() {
        return this.cookie;
    }

    public void resetDisplayName(String displayName) {
        if (!Strings.isNullOrEmpty((String)displayName)) {
            this.displayName = displayName;
        }
    }

    @Override
    public String toString() {
        return "UserLogin:" + this.getName() + " (" + this.getDisplayName() + ")";
    }

    public AuthType getAuthType() {
        return this.authTok != null ? this.authTok.getAuthType() : null;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        UserLogin userLogin = (UserLogin)o2;
        return Objects.equals(this.authTok, userLogin.authTok) && Objects.equals(this.cookie, userLogin.cookie) && Objects.equals(this.displayName, userLogin.displayName) && Objects.equals(this.username, userLogin.username);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.authTok, this.cookie, this.displayName, this.username);
    }
}

