/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoginCookieToken
implements Serializable {
    private static final Pattern DECODER = Pattern.compile("^([^:]+):(\\d+):(.+)");
    private final Long loginId;
    private final String username;
    private final String rnd;

    public LoginCookieToken(Long loginId, String username, String rnd) {
        Preconditions.checkNotNull((Object)loginId);
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull((Object)rnd);
        this.loginId = loginId;
        this.username = username;
        this.rnd = rnd;
    }

    public long getLoginId() {
        return this.loginId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRnd() {
        return this.rnd;
    }

    public String encode() {
        return FishEyeURLEncoder.uriEncode(this.username) + ":" + this.loginId + ":" + this.rnd;
    }

    public static LoginCookieToken decode(String value) {
        Matcher matcher = DECODER.matcher(value);
        if (matcher.matches()) {
            return new LoginCookieToken(Long.parseLong(matcher.group(2)), FishEyeURLEncoder.decode(matcher.group(1)), matcher.group(3));
        }
        Logs.APP_LOG.debug((Object)("Cookie with text '" + value + "' didn't match."));
        return null;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        LoginCookieToken that = (LoginCookieToken)o2;
        if (!this.loginId.equals(that.loginId)) {
            return false;
        }
        if (!this.rnd.equals(that.rnd)) {
            return false;
        }
        return this.username.equals(that.username);
    }

    public int hashCode() {
        int result = this.loginId.hashCode();
        result = 31 * result + this.username.hashCode();
        result = 31 * result + this.rnd.hashCode();
        return result;
    }
}

