/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.LoginCookieToken;
import com.cenqua.fisheye.web.ServletUtils;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;

public class LoginCookie
implements Serializable {
    public static final int REMEMBER_ME = 1;
    public static final int PRECOOKED_URL = 2;
    private Long loginId;
    private FecruUser user;
    protected String rnd;
    private long createDate;
    private int type;
    private String url;
    private boolean recursiveUrl;

    public static LoginCookie createRememberMeCookie(FecruUser user, String rnd) {
        LoginCookie loginCookie = new LoginCookie();
        loginCookie.setType(1);
        loginCookie.setCreateDate(System.currentTimeMillis());
        loginCookie.setUser(user);
        loginCookie.setRnd(rnd);
        return loginCookie;
    }

    public static LoginCookie createPreCookedUrlCookie(FecruUser user, String rnd, String url, boolean recursiveUrl) {
        LoginCookie loginCookie = new LoginCookie();
        loginCookie.setType(2);
        loginCookie.setCreateDate(System.currentTimeMillis());
        loginCookie.setUser(user);
        loginCookie.setRnd(rnd);
        loginCookie.setUrl(url);
        loginCookie.setRecursiveUrl(recursiveUrl);
        return loginCookie;
    }

    public LoginCookieToken getLoginCookieToken() {
        return new LoginCookieToken(this.loginId, this.user.getUsername(), this.rnd);
    }

    public String encode() {
        return this.getLoginCookieToken().encode();
    }

    public Long getLoginId() {
        return this.loginId;
    }

    public void setLoginId(Long loginId) {
        this.loginId = loginId;
    }

    public FecruUser getUser() {
        return this.user;
    }

    public void setUser(FecruUser user) {
        this.user = user;
    }

    public String getRnd() {
        return this.rnd;
    }

    public long getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(long createDate) {
        this.createDate = createDate;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isRecursiveUrl() {
        return this.recursiveUrl;
    }

    public void setRecursiveUrl(boolean recursiveUrl) {
        this.recursiveUrl = recursiveUrl;
    }

    public void setRnd(String rnd) {
        this.rnd = rnd;
    }

    public boolean matches(LoginCookieToken given, HttpServletRequest req) {
        boolean success;
        boolean bl = success = this.getLoginId().longValue() == given.getLoginId() && this.getUser().getUsername().equals(given.getUsername()) && this.getRnd().equals(given.getRnd());
        if (!success) {
            Logs.APP_LOG.debug((Object)("invalid cookie token:\n expected loginid=" + this.getLoginId() + ", actual loginid=" + given.getLoginId() + "\n expected username=" + this.getUser().getUsername() + ", actual username=" + given.getUsername() + "\n expected rnd=" + this.getRnd() + ", actual rnd=" + given.getRnd()));
            return false;
        }
        if (this.getType() == 2) {
            String u2 = ServletUtils.getOriginalPostContextPath(req);
            success = this.isRecursiveUrl() ? u2.startsWith(this.getUrl()) : u2.equals(this.getUrl());
        }
        return success;
    }

    public String toString() {
        return "LoginCookie{user=" + this.user + ", loginId=" + this.loginId + ", type=" + this.type + ", url='" + this.url + '\'' + ", recursiveUrl=" + this.recursiveUrl + '}';
    }
}

