/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.license.LicenseManager;
import com.atlassian.fecru.page.OnePageRequest;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fecru.user.AuthType;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.LoginCookieDAO;
import com.atlassian.fecru.user.UserListChangedEvent;
import com.atlassian.fecru.utils.collectors.ImmutableCollectors;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.AdminUserConfig;
import com.cenqua.fisheye.user.Auth;
import com.cenqua.fisheye.user.AuthTok;
import com.cenqua.fisheye.user.AuthenticationException;
import com.cenqua.fisheye.user.AuthenticationFactory;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.GroupSearchCriteria;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.LoginCookieToken;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserSearchCriteria;
import com.cenqua.fisheye.user.UserUtils;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.WatchDAO;
import com.cenqua.fisheye.web.admin.interceptors.LoginInterceptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspContext;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=UserManager.class)
@Service(value="userManager")
public class DefaultUserManager
implements UserManager {
    private static final Logger log = Logs.loggerFor(DefaultUserManager.class);
    private static final String LASTUSER_SESSION_KEY = UserManager.class.getName() + ".LAST_USER";
    private static final int REMEMBERME_COOKIE_AGE = 31536000;
    private static final SecureRandomService RANDOM = DefaultSecureRandomService.getInstance();
    private static final int NRANDOM_BYTES = 16;
    private final LoginCookieDAO loginCookieDAO;
    private final WatchDAO watchDAO;
    private final FecruUserDAO userDAO;
    private final TxTemplate txTemplate;
    private final AdminUserConfig adminUserConfig;
    private final DirectoryManager directoryManager;
    private final AuthenticationController authenticationController;
    private Auth mAuth;
    private final AuthenticationFactory authFactory;
    private CommitterUserMappingManager committerUserMappingManager;
    private final RootConfig rootConfig;
    private final LicenseManager licenseManager;
    private final UserRepositoryPropertyManager userRepositoryPropertyManager;
    private final CrowdService crowdService;
    private final ApplicationService applicationService;
    private final ApplicationFactory applicationFactory;
    private final GroupMembershipManager groupMembershipManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final EventPublisher eventPublisher;

    @Autowired
    public DefaultUserManager(LoginCookieDAO loginCookieDAO, WatchDAO watchDAO, FecruUserDAO userDAO, TxTemplate txTemplate, RootConfig rootConfig, AuthenticationFactory authFactory, LicenseManager licenseManager, DirectoryManager directoryManager, @Qualifier(value="salAuthenticationController") AuthenticationController authenticationController, UserRepositoryPropertyManager userRepositoryPropertyManager, CrowdService crowdService, ApplicationService applicationService, ApplicationFactory applicationFactory, GroupMembershipManager groupMembershipManager, GlobalPermissionManager globalPermissionManager, AdminUserConfig adminUserConfig, EventPublisher eventPublisher) throws ConfigException {
        this.loginCookieDAO = loginCookieDAO;
        this.watchDAO = watchDAO;
        this.userDAO = userDAO;
        this.txTemplate = txTemplate;
        this.rootConfig = rootConfig;
        this.licenseManager = licenseManager;
        this.directoryManager = directoryManager;
        this.authenticationController = authenticationController;
        this.userRepositoryPropertyManager = userRepositoryPropertyManager;
        this.crowdService = crowdService;
        this.applicationService = applicationService;
        this.applicationFactory = applicationFactory;
        this.groupMembershipManager = groupMembershipManager;
        this.globalPermissionManager = globalPermissionManager;
        this.eventPublisher = eventPublisher;
        this.adminUserConfig = adminUserConfig;
        this.authFactory = authFactory;
    }

    @PostConstruct
    void init() throws ConfigException {
        this.reload(this.rootConfig.getConfig());
    }

    @Autowired
    public void setCommitterUserMappingManager(CommitterUserMappingManager committerUserMappingManager) {
        this.committerUserMappingManager = committerUserMappingManager;
    }

    @Override
    public void reload(ConfigDocument.Config config) throws ConfigException {
        if (this.mAuth != null) {
            this.mAuth.close();
            this.mAuth = null;
        }
        this.mAuth = this.authFactory.getAuth(config.getSecurity());
        this.eventPublisher.publish((Object)new UserListChangedEvent(this));
    }

    @Override
    public UserLogin validateCurrentUser(HttpServletRequest req, HttpServletResponse response) {
        AuthTok authTok;
        UserLogin userLogin = this.getCurrentUser(req);
        try {
            if (userLogin != null && !this.existsLicensedUser(userLogin.getUsername())) {
                this.clearLoginTokens(userLogin, req, response);
                return null;
            }
        }
        catch (Exception e2) {
            log.warn((Object)"Problem logging user out", (Throwable)e2);
            return null;
        }
        if (userLogin != null && userLogin.getAuthType() != this.mAuth.getAuthType()) {
            return userLogin;
        }
        if (userLogin != null && this.authenticationController.shouldAttemptAuthentication(req) && !this.isUserStillValid(req, response, userLogin, authTok = userLogin.getAuthTok())) {
            try {
                this.clearLoginTokens(userLogin, req, response);
            }
            catch (DbException e3) {
                log.warn((Object)"Problem logging user out", (Throwable)e3);
            }
            return null;
        }
        return userLogin;
    }

    private boolean isUserStillValid(HttpServletRequest request, HttpServletResponse response, UserLogin userLogin, AuthTok authTok) {
        try {
            return this.mAuth.isRequestUserStillValid(userLogin, request, response);
        }
        catch (AuthenticationException e2) {
            log.error((Object)("Problem communicating with the authentication provider " + (Object)((Object)authTok.getAuthType())), (Throwable)e2);
            return false;
        }
    }

    @Override
    public UserLogin getCurrentUser(HttpServletRequest req) {
        UserLogin user = (UserLogin)req.getAttribute("feuser");
        if (user != null) {
            return user;
        }
        HttpSession session = req.getSession(false);
        if (session == null) {
            return null;
        }
        return (UserLogin)session.getAttribute("feuser");
    }

    @Override
    public UserLogin getCurrentUser(JspContext ctx) {
        UserLogin user = (UserLogin)ctx.getAttribute("feuser", 2);
        if (user != null) {
            return user;
        }
        try {
            user = (UserLogin)ctx.getAttribute("feuser", 3);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return user;
    }

    @Override
    public LoginCookie preCookUrl(HttpServletRequest req, final String uri, final boolean allowRecursive) {
        final UserLogin userLogin = this.getCurrentUser(req);
        if (userLogin == null) {
            return null;
        }
        return this.txTemplate.execute(new TxCallback<LoginCookie>(){

            @Override
            public LoginCookie doInTransaction(TransactionStatus status) {
                FecruUser user = DefaultUserManager.this.userDAO.getByUsername(userLogin.getUsername());
                Iterator<LoginCookie> cookiesIt = DefaultUserManager.this.loginCookieDAO.findCookies(user, null, 2, uri, allowRecursive).iterator();
                if (cookiesIt.hasNext()) {
                    return cookiesIt.next();
                }
                return DefaultUserManager.this.loginCookieDAO.addCookie(LoginCookie.createPreCookedUrlCookie(user, DefaultUserManager.this.makeSecureRnd(), uri, allowRecursive));
            }
        });
    }

    @Override
    public UserLogin login(HttpServletRequest req, HttpServletResponse resp, String username, String password, boolean rememberme) throws LicensePolicyException {
        if (password == null || "".equals(password)) {
            return null;
        }
        return this.loginWithSanitizedUserName(req, resp, UserUtils.sanitize(username), password, rememberme);
    }

    @Override
    public boolean hasUserExceededLoginAttempts(String userName) {
        FecruUser user;
        if (userName != null && (user = this.getLicensedUser(UserUtils.sanitize(userName))) != null) {
            return this.hasExceededMaxFailedLoginAttempts(user);
        }
        return false;
    }

    private UserLogin loginWithSanitizedUserName(HttpServletRequest req, HttpServletResponse resp, String username, String password, boolean rememberMe) throws LicensePolicyException {
        AuthTok authTok;
        FecruUser user = this.getOrImportUser(req, resp, username, password);
        if (user == null) {
            log.debug((Object)("Login: could not get or import user \"" + username + "\""));
            return null;
        }
        if (!this.existsLicensedUser(username)) {
            log.debug((Object)("Login: " + username + " is not active or doesn't have required global permission to access " + AppConfig.getProductName()));
            return null;
        }
        if (this.hasExceededMaxFailedLoginAttempts(user)) {
            req.setAttribute(LOGIN_ERROR, (Object)UserManager.LoginError.EXCEEDED_MAX_LOGIN_ATTEMPTS);
            log.debug((Object)("Login: exceeded max login attempts for \"" + username + "\""));
            return null;
        }
        try {
            authTok = this.mAuth.authenticate(username, password, req, resp);
        }
        catch (AuthenticationException e2) {
            log.error((Object)("Could not authenticate user \"" + username + '\"'), (Throwable)e2);
            return null;
        }
        if (authTok == null) {
            log.debug((Object)("Authentication for user " + username + " failed"));
            this.incrementFailedLoginsCount(user);
            return null;
        }
        return this.doLogin(req, resp, user, authTok, this.createRememberMeCookie(user, rememberMe));
    }

    private boolean hasExceededMaxFailedLoginAttempts(FecruUser user) {
        long failedLoginAttempts = user.getFailedLoginAttempts();
        SecurityType security = AppConfig.getsConfig().getConfig().getSecurity();
        return security.getEnableLoginCaptcha() && failedLoginAttempts > security.getMaxLoginFailures().longValue();
    }

    private void incrementFailedLoginsCount(FecruUser user) {
        long previousCount = user.getFailedLoginAttempts();
        long newCount = previousCount + 1L;
        this.userDAO.updateFailedLoginAttempts(user, newCount);
        log.debug((Object)("User " + user + " now has " + newCount + " failed login attempts"));
    }

    LoginCookie createRememberMeCookie(final @Nonnull FecruUser user, boolean rememberMe) {
        if (!rememberMe) {
            return null;
        }
        return this.txTemplate.execute(new TxCallback<LoginCookie>(){

            @Override
            public LoginCookie doInTransaction(TransactionStatus status) {
                return DefaultUserManager.this.loginCookieDAO.addCookie(LoginCookie.createRememberMeCookie(user, DefaultUserManager.this.makeSecureRnd()));
            }
        });
    }

    @Override
    public UserLogin login(final HttpServletRequest req, HttpServletResponse resp, final LoginCookieToken given) {
        if (given == null) {
            return null;
        }
        LoginCookie expected = this.txTemplate.execute(new TxCallback<LoginCookie>(){

            @Override
            public LoginCookie doInTransaction(TransactionStatus status) {
                FecruUser user = DefaultUserManager.this.userDAO.getByUsername(given.getUsername());
                if (user == null) {
                    return null;
                }
                LoginCookie loginCookie = DefaultUserManager.this.loginCookieDAO.findCookie(user, given.getLoginId());
                if (loginCookie == null) {
                    return null;
                }
                if (!loginCookie.matches(given, req)) {
                    log.info((Object)String.format("attempt to login using expired/invalid token \"%s\" from %s to URL %s", given.getUsername(), req.getRemoteAddr(), req.getRequestURI()));
                    return null;
                }
                return loginCookie;
            }
        });
        if (expected == null) {
            return null;
        }
        FecruUser user = this.getLicensedUser(expected.getUser().getUsername());
        if (user == null) {
            return null;
        }
        AuthTok auth = null;
        try {
            auth = this.mAuth.recreateAuth(user.getUsername());
        }
        catch (AuthenticationException e2) {
            log.error((Object)("Communication error with " + (Object)((Object)this.mAuth.getAuthType())), (Throwable)e2);
        }
        if (auth == null) {
            log.info((Object)String.format("cannot re-authenticate user \"%s\". They will need to login again", user.getUsername()));
            return null;
        }
        return this.doLogin(req, resp, user, auth, expected);
    }

    private FecruUser getOrImportDelegatedUser(AuthTok authTok) throws LicensePolicyException {
        String username = UserUtils.sanitize(authTok.getUsername());
        FecruUser user = this.getLicensedUser(username);
        if (user != null || !this.mAuth.getAutoAdd()) {
            return user;
        }
        user = this.importUser(authTok);
        return user == null ? null : this.getLicensedUser(user.getUsername());
    }

    @Nullable
    private FecruUser getOrImportUser(HttpServletRequest req, HttpServletResponse resp, String uname, String password) throws LicensePolicyException {
        FecruUser user = this.getUser(uname = UserUtils.sanitize(uname));
        if (user == null) {
            log.debug((Object)("Login: attempting to import user \"" + uname + "\""));
            AuthTok authTok = null;
            try {
                authTok = this.mAuth.authenticate(uname, password, req, resp);
            }
            catch (AuthenticationException e2) {
                log.error((Object)("Could not authenticate user \"" + uname + '\"'), (Throwable)e2);
            }
            if (authTok != null) {
                if (!uname.equals(UserUtils.sanitize(authTok.getUsername()))) {
                    user = this.getUser(UserUtils.sanitize(authTok.getUsername()));
                }
                if (user == null && this.mAuth.getAutoAdd()) {
                    user = this.importUser(authTok);
                }
            }
        }
        return user;
    }

    @VisibleForTesting
    protected FecruUser importUser(AuthTok authTok) {
        String sanitizedUserName = UserUtils.sanitize(authTok.getUsername());
        if (this.isPasswordAdminSpecialUserName(sanitizedUserName)) {
            log.warn((Object)("Ignoring user in the import process because of invalid user name: '" + sanitizedUserName + "'"));
            return null;
        }
        log.debug((Object)("auto-import user: \"" + sanitizedUserName + "\""));
        return this.txTemplate.execute(status -> {
            boolean createdUser = false;
            if (this.crowdService.getUser(sanitizedUserName) == null) {
                User crowdUser = new ImmutableUser.Builder().name(sanitizedUserName).displayName(authTok.getDisplayName()).emailAddress(authTok.getEmail()).toUser();
                this.addCrowdUser(crowdUser, null);
                createdUser = true;
            } else {
                log.debug((Object)("FecruUser " + sanitizedUserName + " already exists, not creating"));
            }
            if (createdUser) {
                this.tryAddUserToDefaultGroups(sanitizedUserName);
            }
            this.eventPublisher.publish((Object)new UserListChangedEvent(this));
            return this.userDAO.getByUsername(sanitizedUserName);
        });
    }

    @Override
    public UserLogin tryRequestDelegatedLogin(HttpServletRequest request, HttpServletResponse response) throws LicensePolicyException {
        AuthTok authTok = null;
        try {
            authTok = this.mAuth.getToken(request, response);
        }
        catch (AuthenticationException e2) {
            log.error((Object)"Could not retrieve the authentication token", (Throwable)e2);
        }
        if (authTok == null) {
            return null;
        }
        FecruUser feUser = this.getOrImportDelegatedUser(authTok);
        if (feUser == null) {
            return null;
        }
        UserLogin userLogin = new UserLogin(feUser, authTok, null);
        request.setAttribute("feuser", (Object)userLogin);
        PreferenceManager.touchCookie(request, response);
        HttpSession session = request.getSession(true);
        session.setAttribute("feuser", (Object)userLogin);
        return userLogin;
    }

    @Override
    public UserLogin createTrustedUserLogin(String username, boolean forceExactMatch, boolean allowAutoAdd) throws LicensePolicyException {
        UserLogin trustedUserLogin = this.createTrustedUserLoginImpl(username, allowAutoAdd);
        if (!forceExactMatch && trustedUserLogin == null) {
            trustedUserLogin = this.createTrustedUserLoginImpl(UserUtils.sanitize(username), allowAutoAdd);
        }
        return trustedUserLogin;
    }

    @Override
    public UserLogin createTrustedUserLogin(String username) throws LicensePolicyException {
        return this.createTrustedUserLogin(username, true, true);
    }

    private UserLogin createTrustedUserLoginImpl(String username, boolean allowAutoAdd) throws LicensePolicyException {
        FecruUser user = this.getLicensedUser(username);
        AuthTok authTok = null;
        try {
            authTok = this.mAuth.recreateAuth(username);
        }
        catch (AuthenticationException e2) {
            log.error((Object)("Communication error with " + (Object)((Object)this.mAuth.getAuthType())), (Throwable)e2);
        }
        if (authTok == null) {
            return null;
        }
        if (user == null && allowAutoAdd) {
            user = this.getOrImportDelegatedUser(authTok);
        }
        return null == user ? null : new UserLogin(user, authTok, null);
    }

    @Override
    public void logout(HttpServletRequest req, HttpServletResponse resp) {
        UserLogin login = this.getCurrentUser(req);
        this.clearLoginTokens(login, req, resp);
        if (login != null && this.mAuth != null) {
            try {
                this.mAuth.logout(login, req, resp);
            }
            catch (AuthenticationException e2) {
                log.error((Object)"Could not logout the user", (Throwable)e2);
            }
        }
    }

    private void clearLoginTokens(UserLogin login, HttpServletRequest req, HttpServletResponse resp) {
        req.removeAttribute("feuser");
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.removeAttribute("feuser");
            session.removeAttribute(LoginInterceptor.SESSION_KEY);
            if (login != null) {
                LastLogin lastLogin = new LastLogin(login.getUsername());
                session.setAttribute(LASTUSER_SESSION_KEY, (Object)lastLogin);
            }
        }
        PreferenceManager.touchCookie(req, resp);
        Cookie c2 = DefaultUserManager.newRememberMeHttpCookie(req, "");
        c2.setMaxAge(0);
        resp.addCookie(c2);
        if (login != null && login.getCookie() != null) {
            final LoginCookie lc = login.getCookie();
            this.txTemplate.execute(new TxCallback<Void>(){

                @Override
                public Void doInTransaction(TransactionStatus status) {
                    DefaultUserManager.this.loginCookieDAO.deleteCookie(lc.getUser(), lc.getLoginId());
                    return null;
                }
            });
        }
    }

    @Override
    public void logout2(HttpServletRequest req, HttpServletResponse resp, boolean clearRemember, boolean clearPrecooked) {
        PreferenceManager.touchCookie(req, resp);
        HttpSession session = req.getSession(false);
        if (session == null) {
            return;
        }
        LastLogin lastLogin = (LastLogin)session.getAttribute(LASTUSER_SESSION_KEY);
        if (lastLogin == null) {
            return;
        }
        session.removeAttribute(LASTUSER_SESSION_KEY);
        session.invalidate();
        long expires = lastLogin.tsCreated + 120000L;
        if (System.currentTimeMillis() > expires) {
            return;
        }
        String username = lastLogin.username;
        log.debug((Object)("level2 logout for \"" + username + "\""));
        this.logout2User(username, clearRemember, clearPrecooked);
    }

    @Override
    public void logout2User(final String username, final boolean clearRemember, final boolean clearPrecooked) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) {
                FecruUser user = DefaultUserManager.this.userDAO.getByUsername(username);
                if (user != null) {
                    if (clearRemember) {
                        DefaultUserManager.this.loginCookieDAO.deleteCookies(user, 1);
                    }
                    if (clearPrecooked) {
                        DefaultUserManager.this.loginCookieDAO.deleteCookies(user, 2);
                    }
                }
                return null;
            }
        });
    }

    private UserLogin doLogin(HttpServletRequest req, HttpServletResponse resp, FecruUser feuser, AuthTok auth, LoginCookie lc) {
        boolean isPreCooked;
        boolean isRememberme = lc != null && lc.getType() == 1;
        boolean bl = isPreCooked = lc != null && lc.getType() == 2;
        if (isRememberme) {
            String val = lc.getLoginCookieToken().encode();
            Cookie c2 = DefaultUserManager.newRememberMeHttpCookie(req, val);
            c2.setMaxAge(31536000);
            resp.addCookie(c2);
        } else {
            Cookie c3 = DefaultUserManager.newRememberMeHttpCookie(req, "");
            c3.setMaxAge(0);
            resp.addCookie(c3);
        }
        UserLogin user = new UserLogin(feuser, auth, lc);
        if (isPreCooked) {
            req.setAttribute("feuser", (Object)user);
        } else {
            PreferenceManager.touchCookie(req, resp);
            HttpSession session = req.getSession(true);
            session.setAttribute("feuser", (Object)user);
        }
        return user;
    }

    private static Cookie newRememberMeHttpCookie(HttpServletRequest req, String val) {
        String ctxPath;
        Cookie c2 = new Cookie("remember", val);
        c2.setHttpOnly(true);
        if (req.isSecure()) {
            c2.setSecure(true);
        }
        if ((ctxPath = req.getContextPath()).length() == 0) {
            ctxPath = "/";
        }
        c2.setPath(ctxPath);
        return c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeSecureRnd() {
        byte[] b2 = new byte[16];
        SecureRandomService secureRandomService = RANDOM;
        synchronized (secureRandomService) {
            RANDOM.nextBytes(b2);
        }
        return StringUtil.hexEncode(b2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeSecureRnd(int length) {
        byte[] b2 = new byte[length];
        SecureRandomService secureRandomService = RANDOM;
        synchronized (secureRandomService) {
            RANDOM.nextBytes(b2);
        }
        return StringUtil.hexEncode(b2).substring(0, length);
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> getAllEnabledUsernames() {
        return ImmutableList.copyOf(this.searchUsersImpl(UserSearchCriteria.create(), null, String.class));
    }

    @Override
    public Iterable<String> getAllLicensedUsernames() {
        return ImmutableList.copyOf(this.globalPermissionManager.getUsersWithPermission(LicenseManager.getLicensedGlobalPermissionType()));
    }

    @Override
    @Transactional(readOnly=true)
    public Page<FecruUser> searchUsers(UserSearchCriteria userSearchCriteria, PageRequest pageRequest) {
        return this.searchUsersPage(userSearchCriteria, pageRequest);
    }

    private Page<FecruUser> searchUsersPage(UserSearchCriteria userSearchCriteria, PageRequest pageRequest) {
        boolean specifiedPermissions = !userSearchCriteria.getGlobalUserPermission().isEmpty();
        Iterable filteredUsers = !specifiedPermissions ? this.searchUsersImpl(userSearchCriteria, pageRequest, User.class) : (Iterable)StreamSupport.stream(this.searchUsersImpl(userSearchCriteria, null, User.class).spliterator(), false).filter(user -> this.globalPermissionManager.hasPermissions(user.getName(), userSearchCriteria.getGlobalUserPermission())).skip(pageRequest.getStart()).limit(pageRequest.getLimit() + 1).collect(ImmutableCollectors.toList());
        Iterable<FecruUser> users = this.userDAO.loadUsers(filteredUsers);
        return Page.Builder.buildFromLimitPlusOneCollection((Collection)ImmutableList.copyOf(users), (PageRequest)pageRequest);
    }

    private <T> Iterable<T> searchUsersImpl(UserSearchCriteria userSearchCriteria, @Nullable PageRequest pageRequest, Class<T> resultType) {
        QueryBuilder.PartialEntityQueryWithRestriction query = QueryBuilder.queryFor(resultType, (EntityDescriptor)EntityDescriptor.user()).with(userSearchCriteria.toRestriction());
        EntityQuery pageQuery = pageRequest == null ? query.returningAtMost(-1) : query.startingAt(pageRequest.getStart()).returningAtMost(pageRequest.getLimit() + 1);
        return this.crowdService.search((Query)pageQuery);
    }

    @Override
    public Page<GroupInfo> searchGroups(GroupSearchCriteria groupSearchCriteria, PageRequest pageRequest) {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)true), Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)Strings.nullToEmpty((String)groupSearchCriteria.prefix()))})).startingAt(pageRequest.getStart()).returningAtMost(pageRequest.getLimit() + 1);
        Iterable groupsFromCrowd = this.crowdService.search((Query)query);
        List groups = StreamSupport.stream(groupsFromCrowd.spliterator(), false).map(this.groupToGroupInfo()).collect(Collectors.toList());
        return Page.Builder.buildFromLimitPlusOneCollection(groups, (PageRequest)pageRequest);
    }

    private Function<Group, GroupInfo> groupToGroupInfo() {
        return group -> new GroupInfo(group.getName(), this.adminUserConfig.isAdminGroup(group.getName()));
    }

    @Override
    public boolean groupExists(String groupName) {
        return this.getGroupInfo(groupName).isPresent();
    }

    @Override
    public Optional<GroupInfo> getGroupInfo(String groupName) {
        return Optional.ofNullable(this.crowdService.getGroup(groupName)).map(this.groupToGroupInfo());
    }

    @Override
    @Transactional
    public GroupInfo addGroup(String groupName) {
        if (!this.isGroupNameValid(groupName)) {
            throw new IllegalArgumentException("Invalid group name, allowed characters are: alphanumeric, underscore, at ('@'), dot, dash or backslash");
        }
        try {
            return this.getGroupInfo(this.crowdService.addGroup((Group)new ImmutableGroup(groupName)).getName()).get();
        }
        catch (InvalidGroupException e2) {
            throw new IllegalArgumentException("error adding group " + groupName, e2);
        }
        catch (OperationNotPermittedException e3) {
            throw new NotPermittedException("error adding group " + groupName, (Throwable)e3);
        }
    }

    @Override
    @Transactional
    public void deleteGroup(String groupName) {
        try {
            this.crowdService.removeGroup((Group)new ImmutableGroup(groupName));
        }
        catch (OperationNotPermittedException e2) {
            throw new NotPermittedException("error deleting group " + groupName, (Throwable)e2);
        }
    }

    @Override
    @Transactional
    public void renameUser(String oldname, String newname) {
        String sanitizedNewname = UserUtils.sanitize(newname);
        if (!this.isUserNameValid(sanitizedNewname)) {
            throw new IllegalArgumentException("Invalid user name'" + sanitizedNewname + "', allowed characters are: " + "alphanumeric, underscore, at ('@'), dot, dash or backslash");
        }
        if (this.getUser(oldname) == null) {
            throw new IllegalArgumentException("User \"" + oldname + "\" does not exist.");
        }
        if (this.getUser(newname) != null) {
            throw new IllegalArgumentException("User \"" + sanitizedNewname + "\" already exists.");
        }
        try {
            this.crowdService.renameUser(ImmutableUser.newUser().name(oldname).toUser(), newname);
        }
        catch (InvalidUserException e2) {
            throw new IllegalArgumentException(e2);
        }
        catch (OperationNotPermittedException e3) {
            throw new NotPermittedException((Throwable)e3);
        }
    }

    @Override
    @Transactional
    public FecruUser addUser(String unsanitizedUsername, String displayName, String email, String password, boolean addToDefaultGroups) throws LicensePolicyException {
        String username = UserUtils.sanitize(unsanitizedUsername);
        Preconditions.checkArgument((boolean)this.isUserNameValid(username), (Object)("Invalid user name '" + username + "' allowed characters are: " + "alphanumeric, underscore, at ('@'), dot, dash or backslash"));
        if (this.existsEnabledUser(username)) {
            throw new IllegalArgumentException("User named \"" + username + "\" already exists.");
        }
        LicenseInfo license = this.rootConfig.getLicense();
        if (license == null || license.getFisheyeLicense() == null) {
            throw new LicensePolicyException("Could not add user \"" + username + "\". " + "Your FishEye license is missing or invalid.");
        }
        User userToCreate = ImmutableUser.newUser().name(username).displayName(displayName).emailAddress(email).toUser();
        this.addCrowdUser(userToCreate, password);
        if (addToDefaultGroups) {
            this.tryAddUserToDefaultGroups(username);
        }
        this.eventPublisher.publish((Object)new UserListChangedEvent(this));
        return this.userDAO.getByUsername(username);
    }

    private void addCrowdUser(User userToCreate, @Nullable String password) {
        try {
            if (password == null) {
                UserTemplate newCrowdUser = new UserTemplate(userToCreate);
                this.applicationService.addUser(this.applicationFactory.getApplication(), newCrowdUser, PasswordCredential.NONE);
            } else {
                this.crowdService.addUser(userToCreate, password);
            }
        }
        catch (InvalidCredentialException | InvalidUserException e2) {
            throw new IllegalArgumentException(e2);
        }
        catch (ApplicationPermissionException | OperationNotPermittedException e3) {
            throw new NotPermittedException(e3);
        }
        catch (OperationFailedException e4) {
            throw new RuntimeException(e4);
        }
    }

    private void tryAddUserToDefaultGroups(String username) {
        LicenseInfo license = this.rootConfig.getLicense();
        this.addToDefaultGroup(username, license.isFishEye(), "fisheye-users", "fisheye");
        this.addToDefaultGroup(username, license.isCrucible(), "crucible-users", "crucible");
    }

    private void addToDefaultGroup(String username, boolean isProductLicensed, String defaultGroupName, String productName) {
        if (isProductLicensed) {
            if (this.groupMembershipManager.tryAddUserToGroup(defaultGroupName, username)) {
                log.debug((Object)("Added user " + username + " to default " + productName + " group " + defaultGroupName));
            }
        } else {
            log.debug((Object)("Not adding user " + username + " to default " + productName + " group " + defaultGroupName + " -- no " + productName + " license or the group doesn't exist"));
        }
    }

    @Override
    @Transactional
    public void changePassword(String username, String newPassword) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        User crowdUser = this.crowdService.getUser(username);
        Preconditions.checkArgument((crowdUser != null ? 1 : 0) != 0, (Object)("User " + username + " does not exist"));
        try {
            this.crowdService.updateUserCredential(crowdUser, newPassword);
        }
        catch (InvalidCredentialException | OperationNotPermittedException e2) {
            throw Throwables.propagate((Throwable)e2);
        }
        FecruUser cruUser = this.userDAO.getByUsername(username);
        this.loginCookieDAO.deleteCookiesForUser(cruUser);
    }

    @Override
    @Transactional
    public void requestPasswordReset(String username, String passwordResetSRnd) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        FecruUser user = this.userDAO.getByUsername(username);
        if (null == user) {
            throw new IllegalArgumentException("User \"" + username + "\" does not exist.");
        }
        this.userDAO.updatePasswordResetSrnd(user, passwordResetSRnd, System.currentTimeMillis());
    }

    @Override
    @Transactional
    public void resetPassword(String username, String newPassword) {
        this.changePassword(username, newPassword);
        FecruUser user = this.userDAO.getByUsername(username);
        this.userDAO.resetPasswordResetSrnd(user);
    }

    @Override
    @Transactional
    public boolean canUpdateUser(String username) {
        Directory directory;
        User user = this.crowdService.getUser(username);
        try {
            directory = this.directoryManager.findDirectoryById(user.getDirectoryId());
        }
        catch (DirectoryNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }

    @Override
    public boolean isPasswordlessAuthenticationEnabled() {
        return this.getAuthenticationProvider().getAuthType() != AuthType.EMBEDDED_CROWD;
    }

    @Override
    @Transactional
    public void updateUser(String username, String displayName, String email) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0, (Object)"username not specified");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)displayName) ? 1 : 0) != 0, (Object)"displayName not specified");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)email) ? 1 : 0) != 0, (Object)"email not specified");
        try {
            this.crowdService.updateUser(ImmutableUser.newUser().name(username).emailAddress(email).displayName(displayName).toUser());
        }
        catch (InvalidUserException e2) {
            throw new IllegalArgumentException(e2);
        }
        catch (OperationNotPermittedException e3) {
            throw new NotPermittedException((Throwable)e3);
        }
    }

    @Override
    public boolean existsLicensedUser(String username) {
        return this.getLicensedUser(username) != null;
    }

    @Override
    public boolean existsEnabledUser(String username) {
        return Optional.ofNullable(this.getUser(username)).filter(FecruUser::isEnabled).isPresent();
    }

    @Override
    public GroupInfo ensureGroupExists(String groupname) throws NotFoundException {
        return this.getGroupInfo(groupname).orElseThrow(() -> new NotFoundException(String.format("Group: %s not found", groupname)));
    }

    public static FecruUser getUserByName(String username) {
        return AppConfig.getsConfig().getUserManager().getLicensedUser(username);
    }

    @Override
    public FecruUser getLicensedUser(String username) {
        return Optional.ofNullable(this.userDAO.getByUsername(username)).filter(FecruUser::isEnabled).filter(user -> this.globalPermissionManager.hasPermission(user.getUsername(), LicenseManager.getLicensedGlobalPermissionType())).orElse(null);
    }

    @Override
    public FecruUser getLicensedUser(int userKey) {
        return Optional.ofNullable(this.userDAO.getById(userKey)).filter(FecruUser::isEnabled).filter(user -> this.globalPermissionManager.hasPermission(user.getUsername(), LicenseManager.getLicensedGlobalPermissionType())).orElse(null);
    }

    @Override
    public FecruUser getUser(String username) {
        return this.userDAO.getByUsername(username);
    }

    @Override
    public Optional<FecruUser> getEnabledUser(String username) {
        return Optional.ofNullable(this.getUser(username)).filter(FecruUser::isEnabled);
    }

    @Override
    public FecruUser getUserById(int userKey) {
        return this.userDAO.getById(userKey);
    }

    @Override
    @Deprecated
    @Transactional(readOnly=true)
    public List<FecruUser> getLicensedUsers() {
        return ImmutableList.copyOf((Iterable)this.searchUsers(UserSearchCriteria.create().withPermissions(LicenseManager.getLicensedGlobalPermissionType()), OnePageRequest.createNoLimit()).getValues());
    }

    @Override
    @Transactional
    public void resetFailedLoginAttempts(String username) {
        FecruUser user = this.getUser(username);
        this.userDAO.updateFailedLoginAttempts(user, 0L);
        log.info((Object)String.format("Reset login failure count for user: %s", user));
    }

    @Override
    @Transactional(readOnly=true)
    public String getUsernameByEmail(String email) {
        Preconditions.checkArgument((email != null ? 1 : 0) != 0, (Object)"No email address specified");
        Page<FecruUser> userPage = this.searchUsers(UserSearchCriteria.create().email(email), PageRequest.create((Integer)0, (Integer)1));
        if (!userPage.isLastPage()) {
            log.warn((Object)"Multiple users matching email");
        }
        if (userPage.getSize() == 0) {
            return null;
        }
        return ((FecruUser)userPage.getValues().iterator().next()).getUsername();
    }

    @Override
    public void deleteUserFully(final String username) {
        this.txTemplate.execute(new TxCallback<Object>(){

            @Override
            public Object doInTransaction(TransactionStatus status) throws Exception {
                FecruUser user = DefaultUserManager.this.userDAO.getByUsername(username);
                User crowdUser = DefaultUserManager.this.crowdService.getUser(username);
                if (crowdUser != null) {
                    DefaultUserManager.this.crowdService.removeUser(crowdUser);
                }
                if (user != null) {
                    DefaultUserManager.this.watchDAO.removeWatchesForUser(user);
                    DefaultUserManager.this.loginCookieDAO.deleteCookiesForUser(user);
                    DefaultUserManager.this.userRepositoryPropertyManager.deleteUserProperties(user);
                }
                DefaultUserManager.this.userDAO.delete(username);
                DefaultUserManager.this.adminUserConfig.removeUser(username);
                return null;
            }
        });
    }

    @Override
    public boolean deleteUserAndRemoveCommitterMappings(String username) {
        FecruUser user = this.getUser(username);
        if (user != null && user.isEnabled()) {
            this.deleteUser(username, true);
        }
        return true;
    }

    @Override
    public boolean deleteMultipleUsersAndRemoveCommitterMappings(List<String> usernames) {
        boolean deleteSuccess;
        boolean bl = deleteSuccess = usernames != null;
        if (deleteSuccess) {
            for (String username : usernames) {
                deleteSuccess &= this.deleteUserAndRemoveCommitterMappings(username);
            }
        }
        return deleteSuccess;
    }

    @Override
    @Transactional
    public void deleteUser(String username, boolean removeUserMappings) {
        try {
            this.crowdService.removeUser(this.crowdService.getUser(username));
        }
        catch (OperationNotPermittedException e2) {
            throw new NotPermittedException("Error removing user from directory", (Throwable)e2);
        }
        FecruUser user = this.userDAO.getByUsername(username);
        if (user != null) {
            this.watchDAO.removeWatchesForUser(user);
            this.loginCookieDAO.deleteCookiesForUser(user);
        }
        this.adminUserConfig.removeUser(username);
        if (removeUserMappings) {
            this.committerUserMappingManager.deleteAllForUser(username);
        }
        log.info((Object)("'" + username + "' has been deactivated in FishEye."));
    }

    @Override
    public boolean hasPermissionToAccess(Principal user, RepositoryHandle handle) {
        if (Principal.Anonymous.isAnon((Principal)user)) {
            return this.rootConfig.isAnonAccessAllowed() && handle.getCfg().isAnonAccessAllowed();
        }
        if (Principal.SuperUser.isSuperUser((Principal)user)) {
            return true;
        }
        if (handle.getCfg().isAnonAccessAllowed() || handle.getCfg().isLoggedInAccessAllowed()) {
            return true;
        }
        AuthTok authTok = ((UserLogin)user).getAuthTok();
        try {
            return authTok.hasPermissionToAccess(handle, () -> {
                if (this.groupMembershipManager.isUserInAnyGivenGroup(user.getUserName(), handle.getCfg().getAllowedGroups())) {
                    return true;
                }
                return this.mAuth != null && this.mAuth.hasPermissionToAccess(authTok, handle.getCfg().isLoggedInAccessAllowed(), handle);
            });
        }
        catch (AuthenticationException e2) {
            log.error((Object)("Could not check whether the user '" + user + "' has access to " + handle.getName()), (Throwable)e2);
            return false;
        }
    }

    @Override
    public boolean isCrucibleEnabled(String username) {
        return Optional.ofNullable(this.getUser(username)).filter(FecruUser::isEnabled).filter(user -> this.globalPermissionManager.hasPermissions(user.getUsername(), GlobalPermissionType.FISHEYE_AND_CRUCIBLE)).isPresent();
    }

    @Override
    public boolean isLoginPossible() {
        boolean signupEnabled = this.rootConfig.getConfig().getSecurity().getBuiltIn().getSignup().getEnabled();
        return this.mAuth.getAutoAdd() || signupEnabled || this.licenseManager.getLicensedUsersCount() > 0;
    }

    @Override
    public boolean hasSysAdminPrivileges(String username) {
        return this.adminUserConfig.isAdminUser(username) || this.adminUserConfig.isInAnAdminGroup(username, this.groupMembershipManager);
    }

    @Override
    public boolean hasSysAdminPrivileges(HttpServletRequest request) {
        UserLogin user = this.getCurrentUser(request);
        return user != null && this.hasSysAdminPrivileges(user.getName());
    }

    @Override
    public FecruUser getUserFor(Principal user) {
        if (Principal.Anonymous.isAnon((Principal)user) || Principal.SuperUser.isSuperUser((Principal)user)) {
            return null;
        }
        return this.getLicensedUser(user.getUserName());
    }

    @Override
    public boolean isValidPassword(String username, String password) {
        return this.mAuth.isValidPassword(username, password);
    }

    public static String getDisplayNameForUser(String username) {
        UserManager instance = AppConfig.getsConfig().getUserManager();
        String displayName = "";
        try {
            FecruUser activeUser = instance.getLicensedUser(username);
            if (activeUser != null) {
                displayName = activeUser.getDisplayName();
            }
        }
        catch (Exception e2) {
            log.warn((Object)("Could not get displayname for username \"" + username + "\", using username instead"));
        }
        if (Strings.isNullOrEmpty((String)displayName)) {
            displayName = username;
        }
        return displayName;
    }

    @Override
    public Auth getAuthenticationProvider() {
        return this.mAuth;
    }

    @Override
    public boolean isUserNameValid(String userName) {
        return !Strings.isNullOrEmpty((String)userName) && USERNAME_PATTERN.matcher((CharSequence)Preconditions.checkNotNull((Object)userName, (Object)"userName")).matches() && userName.length() <= 255;
    }

    private boolean isPasswordAdminSpecialUserName(String userName) {
        return UserManager.USERNAME_NORMALIZATION.apply(Strings.nullToEmpty((String)userName)).equals("$admin$");
    }

    @Override
    public boolean isGroupNameValid(String groupName) {
        return GROUPNAME_PATTERN.matcher((CharSequence)Preconditions.checkNotNull((Object)groupName, (Object)"groupName")).matches();
    }

    @Override
    public boolean isAdminGroup(String groupName) {
        return this.adminUserConfig.isAdminGroup(groupName);
    }

    @Override
    public void setAdminGroup(String groupName, boolean isAdmin) {
        if (isAdmin) {
            this.adminUserConfig.addGroup(groupName);
        } else {
            this.adminUserConfig.removeGroup(groupName);
        }
        try {
            this.adminUserConfig.save();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    static {
        RANDOM.nextBytes(new byte[1]);
    }

    public static class LastLogin
    implements Serializable {
        public final String username;
        public final long tsCreated = System.currentTimeMillis();

        public LastLogin(String username) {
            this.username = username;
        }
    }
}

