/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.UserListChangedEvent;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=GroupMembershipManager.class)
@Service(value="groupMembershipManager")
public class DefaultGroupMembershipManager
implements GroupMembershipManager {
    private static final Logger log = Logs.loggerFor(DefaultGroupMembershipManager.class);
    private final CrowdService crowdService;
    private final FecruUserDAO userDAO;
    private final EventPublisher eventPublisher;

    @Autowired
    public DefaultGroupMembershipManager(CrowdService crowdService, FecruUserDAO userDAO, EventPublisher eventPublisher) {
        this.crowdService = crowdService;
        this.userDAO = userDAO;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public List<String> getGroupsForUser(String userName) {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1);
        Iterable groups = this.crowdService.search((Query)query);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)groups, group -> group.getName()));
    }

    @Override
    public Page<String> getGroupsForUser(String userName, PageRequest pageRequest) {
        List<String> allGroups = this.getGroupsForUser(userName);
        return Page.Builder.buildFromAllDataIterable(allGroups, (PageRequest)pageRequest);
    }

    @Override
    public boolean isUserInGroup(String groupName, String userName) {
        return this.crowdService.isUserMemberOfGroup(userName, groupName);
    }

    @Override
    public boolean isUserInAnyGivenGroup(String userName, List<String> groups) {
        List<String> userGroups = this.getGroupsForUser(userName);
        return !Sets.intersection((Set)Sets.newHashSet(userGroups), (Set)Sets.newHashSet(groups)).isEmpty();
    }

    @Override
    @Transactional
    public boolean tryAddUserToGroup(String groupName, String userName) {
        try {
            this.doAddUserToGroup(groupName, userName);
            return true;
        }
        catch (Exception e2) {
            log.debug((Object)("Failed adding user " + userName + " to group " + groupName), (Throwable)e2);
            return false;
        }
    }

    @Override
    @Transactional
    public void addUserToGroup(String groupName, String userName) {
        this.doAddUserToGroup(groupName, userName);
    }

    private void doAddUserToGroup(String groupName, String userName) {
        User crowdUser = (User)Preconditions.checkNotNull((Object)this.crowdService.getUser(userName), (String)"User %s does not exist", (Object[])new Object[]{userName});
        Group crowdGroup = (Group)Preconditions.checkNotNull((Object)this.crowdService.getGroup(groupName), (String)"Group %s does not exist", (Object[])new Object[]{groupName});
        try {
            this.crowdService.addUserToGroup(crowdUser, crowdGroup);
        }
        catch (OperationNotPermittedException e2) {
            throw new NotPermittedException(String.format("Error adding user %s to group %s", userName, groupName), (Throwable)e2);
        }
        this.eventPublisher.publish((Object)new UserListChangedEvent(this));
    }

    @Override
    @Transactional
    public void removeUserFromGroup(String groupName, String userName) {
        User crowdUser = (User)Preconditions.checkNotNull((Object)this.crowdService.getUser(userName));
        Group crowdGroup = (Group)Preconditions.checkNotNull((Object)this.crowdService.getGroup(groupName));
        try {
            this.crowdService.removeUserFromGroup(crowdUser, crowdGroup);
        }
        catch (OperationNotPermittedException e2) {
            throw new NotPermittedException(String.format("Error removing user %s from group %s", userName, groupName), (Throwable)e2);
        }
        this.eventPublisher.publish((Object)new UserListChangedEvent(this));
    }

    @Override
    public List<FecruUser> getUsersInGroup(String groupName) {
        Group group = this.crowdService.getGroup(groupName);
        if (group == null) {
            return Collections.emptyList();
        }
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1);
        Iterable users = this.crowdService.search((Query)query);
        Iterable<FecruUser> fecruUsers = this.userDAO.loadUsers(users);
        return StreamSupport.stream(fecruUsers.spliterator(), false).filter(FecruUser::isEnabled).collect(Collectors.toList());
    }

    @Override
    public Page<FecruUser> getUsersInGroup(String group, PageRequest pageRequest) {
        List<FecruUser> usersInGroup = this.getUsersInGroup(group);
        return Page.Builder.buildFromAllDataIterable(usersInGroup, (PageRequest)pageRequest);
    }
}

