/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.event.UserRenamedEvent;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.SystemAdmins;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.AdminUserConfig;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultAdminUserConfig
implements AdminUserConfig {
    private final EventPublisher eventPublisher;

    @Autowired
    public DefaultAdminUserConfig(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    public void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public boolean isAdminUser(String username) {
        return this.getItemIndex(this.getSysAdmins().getUserArray(), UserManager.USERNAME_NORMALIZATION.apply(username)) != -1;
    }

    @EventListener
    public void onUserRenamedEvent(UserRenamedEvent event) throws IOException {
        if (this.removeUser(event.getOldUsername())) {
            this.addUser(event.getNewUsername());
        }
        this.save();
    }

    @Override
    public boolean isAdminGroup(String groupName) {
        return this.getGroupSet().contains(UserManager.GROUPNAME_NORMALIZATION.apply(groupName));
    }

    @Override
    public void addUser(String user) {
        if (user != null && !this.isAdminUser(user)) {
            this.getSysAdmins().addUser(UserManager.USERNAME_NORMALIZATION.apply(user));
        }
    }

    @Override
    public void addGroup(String group) {
        String normalizedGroupName;
        if (group != null && !this.isAdminGroup(normalizedGroupName = UserManager.GROUPNAME_NORMALIZATION.apply(group))) {
            this.getSysAdmins().addGroup(normalizedGroupName);
        }
    }

    @Override
    public boolean removeGroup(String group) {
        int index = this.getItemIndex(this.getSysAdmins().getGroupArray(), UserManager.GROUPNAME_NORMALIZATION.apply(group));
        if (index == -1) {
            return false;
        }
        this.getSysAdmins().removeGroup(index);
        return true;
    }

    @Override
    public boolean removeUser(String username) {
        int index = this.getItemIndex(this.getSysAdmins().getUserArray(), UserManager.USERNAME_NORMALIZATION.apply(username));
        if (index == -1) {
            return false;
        }
        this.getSysAdmins().removeUser(index);
        return true;
    }

    private int getItemIndex(String[] array, String target) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (!array[i2].equals(target)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean areSysAdminsSet() {
        return this.getSysAdmins().sizeOfGroupArray() != 0 || this.getSysAdmins().sizeOfUserArray() != 0;
    }

    @Override
    public boolean isInAnAdminGroup(String username, GroupMembershipManager groupMembershipManager) throws DbException {
        for (String group : this.getSysAdmins().getGroupArray()) {
            if (!groupMembershipManager.isUserInGroup(group, username)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("System admins: users ");
        if (this.getSysAdmins().getUserArray() == null) {
            sb.append("[]");
        } else {
            sb.append(Arrays.toString(this.getSysAdmins().getUserArray()));
        }
        sb.append(", groups ");
        if (this.getSysAdmins().getGroupArray() == null) {
            sb.append("[]");
        } else {
            sb.append(Arrays.toString(this.getSysAdmins().getGroupArray()));
        }
        return sb.toString();
    }

    @Override
    public Set<String> getGroupSet() {
        return Sets.newHashSet((Object[])this.getSysAdmins().getGroupArray());
    }

    @Override
    public Set<String> getUserSet() {
        String[] users = this.getSysAdmins().getUserArray();
        return new TreeSet<String>(Arrays.asList(users));
    }

    private SystemAdmins getSysAdmins() {
        return AppConfig.getsConfig().getConfig().getSecurity().getAdmins().getSystemAdmins();
    }

    @Override
    public void save() throws IOException {
        AppConfig.getsConfig().saveConfig();
    }
}

