/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.fecru.user.AuthType;
import com.cenqua.fisheye.config1.CustomRepositoryConfigType;
import com.cenqua.fisheye.config1.CustomSecurityConfigType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.AuthTok;
import com.cenqua.fisheye.user.BaseAuth;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.plugin.AuthToken;
import com.cenqua.fisheye.user.plugin.FishEyeAuthenticator;
import com.cenqua.fisheye.user.plugin.NullFishEyeAuthenticator;
import com.cenqua.fisheye.util.PropertiesUtil;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CustomAuth
extends BaseAuth {
    private final boolean autoAdd;
    private final FishEyeAuthenticator mPlugin;

    public CustomAuth(CustomSecurityConfigType cfg) {
        this(cfg, Logs.APP_LOG);
    }

    public CustomAuth(CustomSecurityConfigType cfg, Logger appLog) {
        super(appLog);
        this.autoAdd = cfg.getAutoAdd();
        this.setPermCacheTTL(cfg.getPositiveCacheTtl());
        String classname = cfg.getClassname();
        Properties p2 = new Properties();
        if (cfg.isSetProperties()) {
            PropertiesUtil.loadFromString(p2, cfg.getProperties());
        }
        NullFishEyeAuthenticator plugin = null;
        try {
            Class<?> clazz;
            Object o2;
            ClassLoader parent = this.getClass().getClassLoader();
            if (parent == null) {
                parent = ClassLoader.getSystemClassLoader();
            }
            if ((o2 = (clazz = parent.loadClass(classname)).newInstance()) instanceof FishEyeAuthenticator) {
                plugin = (FishEyeAuthenticator)o2;
                try {
                    plugin.init(p2);
                }
                catch (Exception e2) {
                    plugin = null;
                    appLog.error((Object)"Error calling init() on the custom authenticator", (Throwable)e2);
                }
            } else {
                appLog.error((Object)("The custom authenticator you supplied (" + classname + ") does not implement " + FishEyeAuthenticator.class.getName()));
            }
        }
        catch (ClassNotFoundException e3) {
            appLog.error((Object)"Could not find your custom authenticator", (Throwable)e3);
        }
        catch (Exception e4) {
            appLog.error((Object)"Problem creating your custom authenticator", (Throwable)e4);
        }
        if (plugin == null) {
            appLog.error((Object)"Could not create your custom authenticator, it will not be used.");
            plugin = new NullFishEyeAuthenticator();
        }
        this.mPlugin = plugin;
    }

    @Override
    public void close() {
        this.mPlugin.close();
    }

    @Override
    public boolean isValidPassword(String username, String password) {
        return this.authenticate(username, password, null, null) != null;
    }

    @Override
    public boolean getAutoAdd() {
        return this.autoAdd;
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.CUSTOM;
    }

    @Override
    public AuthTok authenticate(String username, String password, HttpServletRequest request, HttpServletResponse response) {
        long t0 = System.currentTimeMillis();
        AuthToken tok = this.mPlugin.checkPassword(username, password);
        long t1 = System.currentTimeMillis();
        if (this.appLog.isDebugEnabled()) {
            this.appLog.debug((Object)("custom password check for " + username + " in " + (t1 - t0) + "ms"));
        }
        return tok == null ? null : new CustomAuthTok(this.ttl, tok);
    }

    @Override
    public AuthTok recreateAuth(String username) {
        AuthToken tok = this.mPlugin.recreateAuth(username);
        return tok == null ? null : new CustomAuthTok(this.ttl, tok);
    }

    @Override
    public boolean hasPermissionToAccess(AuthTok atok, boolean defaultResult, RepositoryHandle repository) {
        if (!(atok instanceof CustomAuthTok)) {
            return false;
        }
        CustomAuthTok tok = (CustomAuthTok)atok;
        AuthToken token = tok.tok;
        CustomRepositoryConfigType constraint = repository.getCfg().getCustomAuthConstraint();
        String constraintString = constraint == null ? null : constraint.getConstraint();
        String repname = repository.getName();
        return this.mPlugin.hasPermissionToAccess(token, repname, constraintString);
    }

    @Override
    public AuthTok getToken(HttpServletRequest request, HttpServletResponse response) {
        AuthToken tok = this.mPlugin.checkRequest(request);
        return tok == null ? null : new CustomAuthTok(this.ttl, tok);
    }

    @Override
    public boolean isRequestUserStillValid(UserLogin user, HttpServletRequest request, HttpServletResponse response) {
        return this.mPlugin.isRequestUserStillValid(user.getUsername(), request);
    }

    public static class CustomAuthTok
    extends AuthTok {
        final AuthToken tok;

        public CustomAuthTok(long permCacheTTL, AuthToken tok) {
            super(permCacheTTL);
            this.tok = tok;
        }

        @Override
        public String getEmail() {
            return this.tok.getEmail();
        }

        @Override
        public String getUsername() {
            return this.tok.getUsername();
        }

        @Override
        public String getDisplayName() {
            return this.tok.getDisplayName();
        }

        @Override
        public AuthType getAuthType() {
            return AuthType.CUSTOM;
        }
    }
}

