/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.config1.AjpAuthConfigType;
import com.cenqua.fisheye.config1.CustomSecurityConfigType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.user.AJPAuth;
import com.cenqua.fisheye.user.Auth;
import com.cenqua.fisheye.user.CustomAuth;
import com.cenqua.fisheye.user.embeddedcrowd.EmbeddedCrowdAuth;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationFactory {
    private EmbeddedCrowdAuth embeddedCrowdAuth;

    @Autowired
    @Lazy
    public AuthenticationFactory(EmbeddedCrowdAuth embeddedCrowdAuth) {
        this.embeddedCrowdAuth = embeddedCrowdAuth;
    }

    public Auth getAuth(SecurityType secCfg) {
        if (secCfg.isSetCustom()) {
            CustomSecurityConfigType custom = secCfg.getCustom();
            return new CustomAuth(custom);
        }
        if (secCfg.isSetAjp()) {
            AjpAuthConfigType ajpAuth = secCfg.getAjp();
            return new AJPAuth(ajpAuth);
        }
        return this.embeddedCrowdAuth;
    }
}

