/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.fecru.user.AuthType;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.AuthenticationException;
import com.cenqua.fisheye.util.Pair;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AuthTok
implements Serializable {
    private final ConcurrentMap<String, Pair<Long, Boolean>> repositoryPermsCache;
    private final long repositoryPermsCacheTTL;

    protected AuthTok(long repositoryPermsCacheTTL) {
        this.repositoryPermsCacheTTL = repositoryPermsCacheTTL;
        this.repositoryPermsCache = repositoryPermsCacheTTL == 0L ? null : new ConcurrentHashMap<String, Pair<Long, Boolean>>();
    }

    public final boolean hasPermissionToAccess(RepositoryHandle handle, Callable<Boolean> permissionChecker) throws AuthenticationException {
        try {
            if (this.repositoryPermsCache == null) {
                return permissionChecker.call();
            }
            Pair cached = (Pair)this.repositoryPermsCache.get(handle.getName());
            if (cached != null) {
                boolean expired;
                long timestamp = (Long)cached.getFirst();
                long expires = timestamp + this.repositoryPermsCacheTTL;
                boolean bl = expired = expires < System.currentTimeMillis();
                if (expired) {
                    this.repositoryPermsCache.remove(handle.getName(), cached);
                } else {
                    return (Boolean)cached.getSecond();
                }
            }
            boolean result = permissionChecker.call();
            this.repositoryPermsCache.put(handle.getName(), Pair.newInstance(System.currentTimeMillis(), result));
            return result;
        }
        catch (Exception e2) {
            throw new AuthenticationException((Throwable)e2);
        }
    }

    public abstract String getEmail();

    public abstract String getUsername();

    public abstract String getDisplayName();

    public abstract AuthType getAuthType();
}

