/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.atlassian.fecru.user.AuthType;
import com.cenqua.fisheye.config1.AjpAuthConfigType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.AuthTok;
import com.cenqua.fisheye.user.BaseAuth;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserUtils;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AJPAuth
extends BaseAuth {
    private final boolean isAutoAdd;

    public AJPAuth(AjpAuthConfigType cfg) {
        this(cfg, Logs.APP_LOG);
    }

    public AJPAuth(AjpAuthConfigType cfg, Logger appLog) {
        super(appLog);
        this.isAutoAdd = cfg.getAutoAdd();
    }

    @Override
    public boolean getAutoAdd() {
        return this.isAutoAdd;
    }

    @Override
    public AuthTok authenticate(String username, String password, HttpServletRequest request, HttpServletResponse response) {
        if (!Objects.equals(username, request.getRemoteUser())) {
            return null;
        }
        return this.checkUsername(username);
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.AJP;
    }

    @Override
    public AuthTok recreateAuth(String username) {
        return this.checkUsername(username);
    }

    @Override
    public AuthTok getToken(HttpServletRequest request, HttpServletResponse response) {
        String username = this.getRemoteUser(request);
        return this.checkUsername(username);
    }

    @Override
    public boolean isRequestUserStillValid(UserLogin user, HttpServletRequest request, HttpServletResponse response) {
        String username = user.getUsername();
        if (!username.equals(this.getRemoteUser(request))) {
            Logs.APP_LOG.info((Object)("User: '" + username + "' does not match request delegated user: '" + this.getRemoteUser(request) + "'"));
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidPassword(String username, String password) {
        throw new IllegalStateException("AJP authentication doesn't support password checking");
    }

    private AuthTok checkUsername(String username) {
        return username != null ? new AjpAuthTok(this.ttl, username) : null;
    }

    private String getRemoteUser(HttpServletRequest request) {
        String username = request.getRemoteUser();
        if (username == null) {
            return null;
        }
        return UserUtils.sanitize(username);
    }

    public static class AjpAuthTok
    extends AuthTok {
        private final String username;

        AjpAuthTok(long permCacheTTL, String username) {
            super(permCacheTTL);
            this.username = username;
        }

        @Override
        public String getEmail() {
            return null;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public String getDisplayName() {
            return null;
        }

        @Override
        public AuthType getAuthType() {
            return AuthType.AJP;
        }
    }
}

