/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.MatchRule;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import java.util.HashMap;

public class StringMatchRule
extends MatchRule {
    private String string;

    public StringMatchRule(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid String for StringMatchRule.");
        }
        this.string = string;
    }

    @Override
    public boolean process(InputState input, RegionList outputRegions) {
        CharSequence chars = input.getRemainingChars();
        int length = this.string.length();
        if (chars.length() < length) {
            return true;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (chars.charAt(i2) == this.string.charAt(i2)) continue;
            return true;
        }
        int offset = input.getOffset();
        HashMap<String, Region> matchRegions = new HashMap<String, Region>();
        matchRegions.put("0", new Region(offset, offset + length));
        return this.performAction(input, length, matchRegions, outputRegions);
    }

    public String getString() {
        return this.string;
    }

    public String toString() {
        return "StringMatchRule{string=" + this.string + ";action=" + this.action + "}";
    }
}

