/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.fisheye.util.SortedList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

class SortedRegionSet
implements Iterable<Region> {
    static LineSegmentComparator COMP = new LineSegmentComparator();
    final SortedList<LineSegment> segs = new SortedList<LineSegment>(COMP);

    SortedRegionSet() {
    }

    public int indexOfFirstAt(int x2) {
        if (this.segs.isEmpty()) {
            return -1;
        }
        LineSegment cmp = new LineSegment(new Region(x2, Integer.MAX_VALUE), 0);
        int idx = this.segs.binarySearch(cmp);
        for (int i2 = idx - 1; i2 >= 0; --i2) {
            LineSegment prev = this.segs.get(i2);
            if (prev.maxEndOffset < x2) break;
            if (!prev.region.contains(x2)) continue;
            idx = i2;
        }
        return idx < this.segs.size() ? idx : this.segs.size() - 1;
    }

    public Region get(int i2) {
        LineSegment s2 = this.segs.get(i2);
        return s2.region;
    }

    @Override
    public Iterator<Region> iterator() {
        return new UnwrapppingIterator(this.segs.iterator());
    }

    public Iterator<Region> iterateBetween(final int startOff, final int endOff) {
        final int startIdx = this.indexOfFirstAt(startOff);
        if (startIdx == -1) {
            List tmpList = Collections.emptyList();
            return tmpList.iterator();
        }
        return new Iterator<Region>(){
            int i;
            LineSegment next;
            {
                this.i = startIdx;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                this.next = null;
                while (this.i < SortedRegionSet.this.segs.size()) {
                    LineSegment seg = SortedRegionSet.this.segs.get(this.i);
                    if (seg.region.getStart() >= endOff) {
                        return false;
                    }
                    ++this.i;
                    if (seg.region.getEnd() <= startOff) continue;
                    this.next = seg;
                    break;
                }
                return this.next != null;
            }

            @Override
            public Region next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Region r2 = this.next.region;
                this.next = null;
                return r2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.segs.size();
    }

    public void clear() {
        this.segs.clear();
    }

    public void addAll(SortedRegionSet regions) {
        for (Region r2 : regions) {
            this.add(r2);
        }
    }

    public void add(Region r2) {
        LineSegment seg = new LineSegment(r2, this.segs.size());
        int insertIdx = this.segs.addAndReturnIndex(seg);
        if (insertIdx > 0) {
            LineSegment prev = this.segs.get(insertIdx - 1);
            seg.maxEndOffset = Math.max(seg.maxEndOffset, prev.maxEndOffset);
        }
        for (int i2 = insertIdx + 1; i2 < this.segs.size(); ++i2) {
            LineSegment b2 = this.segs.get(i2);
            if (b2.maxEndOffset >= seg.maxEndOffset) break;
            b2.maxEndOffset = seg.maxEndOffset;
        }
    }

    public String toString() {
        return "SortedRegionSet: " + (this.segs.isEmpty() ? "Empty" : "[" + this.get(0).getStart() + "..." + this.get(this.segs.size() - 1).getEnd() + "]");
    }

    static class LineSegment {
        final Region region;
        final int insertionOrder;
        int maxEndOffset;

        public LineSegment(Region region, int insertionOrder) {
            this.region = region;
            this.insertionOrder = insertionOrder;
            this.maxEndOffset = region.getEnd();
        }
    }

    static class UnwrapppingIterator
    implements Iterator<Region> {
        private final Iterator<LineSegment> i;

        public UnwrapppingIterator(Iterator<LineSegment> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Region next() {
            LineSegment s2 = this.i.next();
            return s2.region;
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }

    static class LineSegmentComparator
    implements Comparator<LineSegment> {
        LineSegmentComparator() {
        }

        @Override
        public int compare(LineSegment obj1, LineSegment obj2) {
            int s2;
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            Region reg1 = obj1.region;
            Region reg2 = obj2.region;
            int s1 = reg1.getStart();
            if (s1 == (s2 = reg2.getStart())) {
                int e2;
                int e1 = reg1.getEnd();
                if (e1 == (e2 = reg2.getEnd())) {
                    if (obj1.insertionOrder == obj2.insertionOrder) {
                        return LineSegmentComparator.compareProps(obj1.region.getProperties(), obj2.region.getProperties());
                    }
                    return CompareUtil.compareTo(obj1.insertionOrder, obj2.insertionOrder);
                }
                if (e1 < e2) {
                    return 1;
                }
                return -1;
            }
            if (s1 > s2) {
                return 1;
            }
            return -1;
        }

        private static int compareProps(Map p1, Map p2) {
            int s2;
            if (p1 == null && p2 == null || p1 == p2) {
                return 0;
            }
            if (p1 == null) {
                return -1;
            }
            if (p2 == null) {
                return 1;
            }
            int s1 = p1.size();
            if (s1 == (s2 = p2.size())) {
                return p1.hashCode() - p2.hashCode();
            }
            if (s1 > s2) {
                return 1;
            }
            return -1;
        }
    }
}

