/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionListRenderer;
import com.cenqua.fisheye.syntax.RegionListVisitor;
import java.io.IOException;
import java.io.Writer;

public class RegionListRenderingVisitor
implements RegionListVisitor {
    private final int endOffset;
    private final Writer writer;
    private final CharSequence chars;
    private final RegionListRenderer renderer;
    private int lastStart = 0;
    private int lastEnd;

    public RegionListRenderingVisitor(int startOffset, int endOffset, Writer writer, CharSequence chars, RegionListRenderer renderer) {
        this.lastEnd = startOffset;
        this.endOffset = endOffset;
        this.writer = writer;
        this.chars = chars;
        this.renderer = renderer;
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void regionStart(Region region) throws IOException {
        if (this.lastEnd < region.getStart()) {
            this.renderer.renderUpToRegionStart(region, this.writer, this.chars.subSequence(this.lastEnd, region.getStart()));
            this.lastEnd = region.getStart();
        }
        this.renderer.renderRegionStart(region, this.writer);
        this.lastStart = region.getStart();
    }

    @Override
    public void regionEnd(Region region) throws IOException {
        int outputFrom = Math.max(this.lastEnd, this.lastStart);
        this.renderer.renderUpToRegionEnd(region, this.writer, this.chars.subSequence(outputFrom, region.getEnd()));
        this.renderer.renderRegionEnd(region, this.writer);
        this.lastEnd = region.getEnd();
    }

    @Override
    public void end() throws IOException {
        this.renderer.renderEnd(this.writer, this.chars.subSequence(this.lastEnd, this.endOffset));
    }
}

