/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.util.VariableSubstituter;
import java.util.HashMap;
import java.util.Map;

public class RegionGenerator {
    private String submatchRef = "0";
    private Map<String, String> properties = new HashMap<String, String>();

    public String getSubmatchRef() {
        return this.submatchRef;
    }

    public void setSubmatchRef(String submatchRef) {
        this.submatchRef = submatchRef;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void generate(InputState input, Map<String, Region> matchRegions, RegionList outputRegions) {
        Region region = matchRegions.get(this.submatchRef);
        if (region != null) {
            outputRegions.add(new Region(region, this.processPropertyValues(input, matchRegions)));
        }
    }

    private Map<String, String> processPropertyValues(InputState input, Map<String, Region> matchRegions) {
        HashMap<String, String> newprops = new HashMap<String, String>();
        for (Map.Entry<String, String> e2 : this.properties.entrySet()) {
            String key = e2.getKey();
            String val = e2.getValue();
            newprops.put(key, this.substituteRefs(input, val, matchRegions));
        }
        return newprops;
    }

    private String substituteRefs(final InputState input, String val, final Map<String, Region> matchRegions) {
        return VariableSubstituter.substituteRefs((CharSequence)val, new VariableSubstituter.VariableMap(){

            @Override
            public CharSequence map(String variable) {
                Region region = (Region)matchRegions.get(variable);
                return region == null ? null : input.getSubSequence(region);
            }
        });
    }

    public String toString() {
        String res = "RegionGenerator{submatch=" + this.submatchRef + ";props={";
        String sep = "";
        for (Map.Entry<String, String> e2 : this.properties.entrySet()) {
            String key = e2.getKey();
            String val = e2.getValue();
            res = res + sep + key + "=" + val;
            sep = ",";
        }
        res = res + "}}";
        return res;
    }
}

