/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Region {
    private int start;
    private int end;
    private Map<String, String> properties;

    public Region(int start, int end, Map<String, String> properties) {
        this.guardBounds(start, end);
        this.start = start;
        this.end = end;
        if (properties != null) {
            this.properties = Collections.unmodifiableMap(new HashMap<String, String>(properties));
        }
    }

    public Region(Region that, Map<String, String> properties) {
        this.start = that.start;
        this.end = that.end;
        if (properties != null) {
            this.properties = Collections.unmodifiableMap(new HashMap<String, String>(properties));
        }
    }

    public Region(int start, int end) {
        this(start, end, null);
    }

    public Region subRegion(int start, int end) {
        if (start < this.start || end > this.end) {
            throw new IndexOutOfBoundsException();
        }
        return new Region(start, end, this.properties);
    }

    public Region translate(int delta) {
        return new Region(this.start + delta, this.end + delta, this.properties);
    }

    public Region resize(int newStart, int newEnd) {
        return new Region(newStart, newEnd, this.properties);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getPropertyValue(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean contains(int x2) {
        return this.start <= x2 && x2 <= this.end;
    }

    public boolean isNestedBy(Region r2) {
        return r2.start <= this.start && r2.end >= this.end;
    }

    public boolean nests(Region r2) {
        return this.start <= r2.start && this.end >= r2.end;
    }

    public boolean overlapsNotNested(Region r2) {
        if (this.start < r2.start && r2.start < this.end && r2.end > this.end) {
            return true;
        }
        return this.start < r2.end && r2.end < this.end && r2.start < this.start;
    }

    public Region intersection(Region r2) {
        if (r2.start < this.start) {
            if (r2.end < this.start) {
                return null;
            }
            if (r2.end == this.start) {
                return null;
            }
            if (r2.end <= this.end) {
                return new Region(this.start, r2.end, r2.properties);
            }
            return new Region(this.start, this.end, r2.properties);
        }
        if (r2.start > this.end) {
            return null;
        }
        if (r2.start == this.end) {
            return null;
        }
        if (r2.end <= this.end) {
            return new Region(r2.start, r2.end, r2.properties);
        }
        return new Region(r2.start, this.end, r2.properties);
    }

    public boolean sameSpan(Region r2) {
        return r2.getStart() == this.getStart() && r2.getEnd() == this.getEnd();
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("Region{st=").append(this.start).append(",end=").append(this.end).append(",props{");
        String sep = "";
        if (this.properties != null) {
            for (Map.Entry<String, String> e2 : this.properties.entrySet()) {
                String key = e2.getKey();
                String val = e2.getValue();
                res.append(sep).append(key).append("=").append(val);
                sep = ",";
            }
        }
        res.append("}}");
        return res.toString();
    }

    private void guardBounds(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start index " + start + " < 0");
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException("end index " + end + " < 0");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start index " + start + " > end index " + end);
        }
    }
}

