/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionFilter;

public class ParenthesesBalancingRegionFilter
implements RegionFilter {
    public static final char OPENING_PAREN = '(';
    public static final char CLOSING_PAREN = ')';

    @Override
    public Region filter(CharSequence input, Region region) {
        boolean isTrailing = true;
        int numTrailingParens = 0;
        int numClosingParens = 0;
        Region result = region;
        if (input.charAt(region.getEnd() - 1) == ')') {
            for (int i2 = region.getEnd() - 1; i2 != region.getStart(); --i2) {
                char current = input.charAt(i2);
                if (isTrailing && current == ')') {
                    ++numTrailingParens;
                } else if (isTrailing) {
                    isTrailing = false;
                } else if (current == ')') {
                    ++numClosingParens;
                }
                if (current != '(') continue;
                if (numClosingParens == 0) {
                    --numTrailingParens;
                    continue;
                }
                --numClosingParens;
            }
            if (numTrailingParens > 0) {
                result = region.resize(region.getStart(), region.getEnd() - numTrailingParens);
            }
        }
        return result;
    }
}

