/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.atlassian.fecru.util.Patterns;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.ContextDefinition;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.MatchAction;
import com.cenqua.fisheye.syntax.MatchPredicate;
import com.cenqua.fisheye.syntax.MatchRule;
import com.cenqua.fisheye.syntax.RegexpMatchRule;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.StringMatchRule;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class MultiMatchRule
extends MatchRule {
    final Iterable<MatchRule> matchRules;
    final Pattern multiPattern;
    private static Function<MatchRule, Pattern> matchRuleToPatternFunction = new Function<MatchRule, Pattern>(){

        public Pattern apply(@Nullable MatchRule matchRule) {
            if (matchRule instanceof RegexpMatchRule) {
                RegexpMatchRule regexpMatchRule = (RegexpMatchRule)matchRule;
                return regexpMatchRule.getPattern();
            }
            if (matchRule instanceof StringMatchRule) {
                StringMatchRule stringMatchRule = (StringMatchRule)matchRule;
                return Pattern.compile(Pattern.quote(stringMatchRule.getString()));
            }
            throw new IllegalArgumentException(matchRule + " should be either RegexpMatchRule or StringMatchRule");
        }
    };

    public MultiMatchRule(Iterable<MatchRule> matchRules) {
        this.matchRules = matchRules;
        this.multiPattern = Patterns.combine(Iterables.transform(matchRules, matchRuleToPatternFunction));
    }

    @Override
    public boolean process(InputState input, RegionList outputRegions) {
        try {
            return this.processInternal(input, outputRegions);
        }
        catch (StackOverflowError e2) {
            input.setParserOverflowOccured();
            int offset = input.getOffset();
            CharSequence chars = input.getFullChars();
            CharSequence errorPart = chars.subSequence(offset, Math.min(offset + 10, chars.length()));
            Logs.APP_LOG.warn((Object)String.format("Error parsing file with multiline pattern %s, on file %s and offset %d, starting with: %s", this.multiPattern.pattern(), input.getFileName(), offset, errorPart), (Throwable)e2);
            return true;
        }
    }

    private boolean processInternal(InputState input, RegionList outputRegions) {
        Matcher m2 = this.multiPattern.matcher(input.getFullChars());
        if (m2.find(input.getOffset())) {
            input.resetOffset(m2.start());
            for (MatchRule matchRule : this.matchRules) {
                if (!matchRule.process(input, outputRegions)) {
                    return false;
                }
                if (input.getOffset() <= m2.start()) continue;
                break;
            }
        } else {
            input.resetOffset(input.length());
        }
        return true;
    }

    @Override
    public void resolveRefs(ContextDefinition parent) {
        for (MatchRule matchRule : this.matchRules) {
            matchRule.resolveRefs(parent);
        }
    }

    @Override
    public void setAction(MatchAction action) {
        throw new IllegalStateException("method call not allowed");
    }

    @Override
    public void setPredicate(MatchPredicate predicate) {
        throw new IllegalStateException("method call not allowed");
    }

    @Override
    public void setPredicate(String predicateClass) throws ClassNotFoundException {
        throw new IllegalStateException("method call not allowed");
    }

    @Override
    protected boolean performAction(InputState input, int charCount, Map<String, Region> matchRegions, RegionList outputRegions) {
        throw new IllegalStateException("method call not allowed");
    }
}

