/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.ContextDefinition;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.MatchAction;
import com.cenqua.fisheye.syntax.MatchPredicate;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import java.util.Map;

public abstract class MatchRule {
    protected MatchPredicate predicate;
    protected MatchAction action;

    public abstract boolean process(InputState var1, RegionList var2);

    public void setAction(MatchAction action) {
        this.action = action;
    }

    public void setPredicate(MatchPredicate predicate) {
        this.predicate = predicate;
    }

    public void setPredicate(String predicateClass) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(predicateClass);
            this.setPredicate((MatchPredicate)clazz.newInstance());
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("problem loading predicate " + predicateClass), (Throwable)e2);
            throw new ClassNotFoundException("Could not find specified predicate class " + predicateClass, e2);
        }
    }

    protected boolean performAction(InputState input, int charCount, Map<String, Region> matchRegions, RegionList outputRegions) {
        if (this.predicate == null || this.predicate.checkMatch(input, matchRegions)) {
            input.consume(charCount);
            return this.action.perform(input, matchRegions, outputRegions);
        }
        return true;
    }

    public void resolveRefs(ContextDefinition parent) {
        this.action.resolveContextRefs(parent);
    }
}

