/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.ContextDefinition;
import com.cenqua.fisheye.syntax.ContextReference;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionFilter;
import com.cenqua.fisheye.syntax.RegionGenerator;
import com.cenqua.fisheye.syntax.RegionList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MatchAction {
    private List<ContextReference> contextRefs = new ArrayList<ContextReference>();
    private List<RegionGenerator> regionGenerators = new ArrayList<RegionGenerator>();
    private List<RegionFilter> filters = new ArrayList<RegionFilter>();
    public static final MatchAction EXIT_CONTEXT_ACTION = new MatchAction(){

        @Override
        public boolean perform(InputState input, Map<String, Region> matchRegions, RegionList outputRegions) {
            return false;
        }
    };
    public static final MatchAction NOOP_ACTION = new MatchAction(){

        @Override
        public boolean perform(InputState input, Map<String, Region> matchRegions, RegionList outputRegions) {
            return true;
        }
    };

    public void addFilter(String classname) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(classname);
            RegionFilter f2 = (RegionFilter)clazz.newInstance();
            this.filters.add(f2);
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)("problem finding filter " + classname), (Throwable)e2);
            throw new ClassNotFoundException("Could not find specified filter class " + classname);
        }
    }

    public boolean perform(InputState input, Map<String, Region> matchRegions, RegionList outputRegions) {
        if (this.contextRefs.size() > 0) {
            for (ContextReference contextReference : this.contextRefs) {
                if (contextReference.getSubmatchRef() != null) {
                    Region submatchRegion = matchRegions.get(contextReference.getSubmatchRef());
                    if (submatchRegion == null) continue;
                    RegionList subRegions = new RegionList();
                    InputState subInput = input.getSubInputState(submatchRegion);
                    contextReference.getContextDefinition().generateRegions(subInput, subRegions);
                    subRegions.translate(submatchRegion.getStart());
                    outputRegions.addAll(subRegions);
                    continue;
                }
                contextReference.getContextDefinition().generateRegions(input, outputRegions);
            }
            Region start = matchRegions.get("0");
            int n2 = start.getStart();
            int allEnd = input.getOffset();
            matchRegions.put("ALL", new Region(n2, allEnd));
        }
        if (this.filters.size() > 0) {
            for (Map.Entry entry : matchRegions.entrySet()) {
                Region current = (Region)entry.getValue();
                current = this.filterRegion(input.getFullChars(), current);
                matchRegions.put((String)entry.getKey(), current);
            }
        }
        for (RegionGenerator regionGenerator : this.regionGenerators) {
            regionGenerator.generate(input, matchRegions, outputRegions);
        }
        return true;
    }

    public void addContextRef(ContextReference contextRef) {
        this.contextRefs.add(contextRef);
    }

    public void resolveContextRefs(ContextDefinition parent) {
        for (ContextReference contextRef : this.contextRefs) {
            ContextDefinition cd = parent.getContextDef(contextRef);
            if (cd == null) {
                throw new RuntimeException(contextRef.getLine() + ":" + contextRef.getColumn() + ": unknown context '" + contextRef.getName() + "'");
            }
            contextRef.setContextDefinition(cd);
        }
    }

    public void addRegionGenerator(RegionGenerator re) {
        this.regionGenerators.add(re);
    }

    public String toString() {
        String res = "MatchAction{contextRefs={";
        String sep = "";
        for (ContextReference contextRef : this.contextRefs) {
            res = res + sep + contextRef;
            sep = ",";
        }
        res = res + "};regionGenerators={";
        sep = "";
        for (RegionGenerator regionGenerator : this.regionGenerators) {
            res = res + sep + regionGenerator;
            sep = ",";
        }
        res = res + "}}";
        return res;
    }

    private Region filterRegion(CharSequence sequence, Region region) {
        for (RegionFilter f2 : this.filters) {
            region = f2.filter(sequence, region);
        }
        return region;
    }
}

