/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.crucible.fisheye.CrucibleProjectHighlighter;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fisheye.web.NavBuilder;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.config1.LinkerType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="linkerFactory")
public class LinkerFactory {
    public static final String JIRA_LINK = "jiralink";
    public static final String CRU_LINK = "crulink";
    private EntityLinkService entityLinkService;
    private ProjectManager projectManager;
    private RepositoryManager repositoryManager;
    private CrucibleProjectHighlighter crucibleProjectHighlighter;
    private final LoadingCache<LinkerKey, Linker> jiraLinkerCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<LinkerKey, Linker>(){

        public Linker load(LinkerKey key) throws Exception {
            return LinkerFactory.this.buildJiraLinker(key);
        }
    });
    private final Object crucibleLinkerLock = new Object();
    private Linker crucibleLinker;

    @Autowired
    public LinkerFactory(EntityLinkService entityLinkService, ProjectManager projectManager, RepositoryManager repositoryManager, CrucibleProjectHighlighter crucibleProjectHighlighter, EventPublisher eventPublisher) {
        this.entityLinkService = entityLinkService;
        this.projectManager = projectManager;
        this.repositoryManager = repositoryManager;
        this.crucibleProjectHighlighter = crucibleProjectHighlighter;
        eventPublisher.register((Object)this);
    }

    public Linker getJiraLinker(String repName, String cruProjectKey) {
        try {
            return (Linker)this.jiraLinkerCache.get((Object)new LinkerKey(repName, cruProjectKey));
        }
        catch (ExecutionException e2) {
            Logs.APP_LOG.error((Object)"Got exception building linkers", (Throwable)e2);
            return Linker.NO_OP;
        }
    }

    private Linker buildJiraLinker(LinkerKey linkerKey) {
        HashSet<EntityLink> linkedProjects = new HashSet<EntityLink>();
        if (linkerKey.repoName != null) {
            RepositoryHandle handle = this.repositoryManager.getRepository(linkerKey.repoName);
            if (handle == null) {
                Logs.APP_LOG.warn((Object)("Failed to get Repository handle for repository " + linkerKey.repoName));
            } else {
                Iterables.addAll(linkedProjects, (Iterable)this.entityLinkService.getEntityLinks((Object)handle, JiraProjectEntityType.class));
            }
        }
        if (linkerKey.projectKey != null) {
            Project project = this.projectManager.getProjectByKey(linkerKey.projectKey);
            if (project == null) {
                Logs.APP_LOG.warn((Object)("Failed to get Project for project key " + linkerKey.projectKey));
            } else {
                Iterables.addAll(linkedProjects, (Iterable)this.entityLinkService.getEntityLinks((Object)project, JiraProjectEntityType.class));
            }
        }
        return LinkerFactory.generateJiraSyntaxDef(linkedProjects);
    }

    public static String getPopupLinkSpanClass(Region region) {
        if (JIRA_LINK.equals(region.getPropertyValue("type"))) {
            return "jira-hover-trigger";
        }
        if (CRU_LINK.equals(region.getPropertyValue("type"))) {
            return "crulinkspan";
        }
        return null;
    }

    public Linker createRepositoryLinker(LinkerType repLinker) {
        Linker linker = new Linker();
        if (repLinker != null) {
            linker.addHighlighter(LinkerFactory.createSyntaxDefForLinkerDef(repLinker));
        }
        linker.addHighlighters(AppConfig.getsConfig().getDefaultLinker());
        return linker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Linker getCrucibleLinker() {
        Object object = this.crucibleLinkerLock;
        synchronized (object) {
            if (this.crucibleLinker == null) {
                this.crucibleLinker = new Linker();
                if (AppConfig.isCrucible() && !AppConfig.isTestMode()) {
                    this.crucibleLinker.addHighlighter(this.crucibleProjectHighlighter);
                }
            }
            return this.crucibleLinker;
        }
    }

    public static Linker createDefaultRepositoryLinker(LinkerType defaults, SyntaxDefinitions syntaxDefinitions) {
        SyntaxDefinition url;
        Linker defaultLinker = new Linker();
        SyntaxDefinition repDefaultsLinker = LinkerFactory.createSyntaxDefForLinkerDef(defaults);
        defaultLinker.addHighlighter(repDefaultsLinker);
        if (syntaxDefinitions != null && (url = syntaxDefinitions.getByFileName("url.def")) != null) {
            defaultLinker.addHighlighter(url);
        }
        return defaultLinker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCrucibleLinkerCache() {
        Object object = this.crucibleLinkerLock;
        synchronized (object) {
            this.crucibleLinker = null;
        }
    }

    @EventListener
    public void notifyEvent(Object event) {
        if (event.getClass().getPackage().getName().startsWith("com.atlassian.applinks.api.event")) {
            this.clearJiraLinkerCache();
        }
    }

    public void clearJiraLinkerCache() {
        this.jiraLinkerCache.invalidateAll();
    }

    public static void appendCommentFormatterRules(StringBuilder buf, String re, String href) {
        LinkerFactory.appendCommentFormatterRules(buf, re, href, "bugid", "");
    }

    public static void appendCommentFormatterRules(StringBuilder buf, String re, String href, String type, String subMatchRef) {
        re = LinkerFactory.replace(re, "/", "\\/");
        href = LinkerFactory.replace(href, "\"", "\\\"");
        buf.append("/").append(re).append("/ : { region " + subMatchRef + "{\n");
        buf.append("href=\"").append(href).append("\";\n");
        buf.append("type=").append(type).append(";\n");
        buf.append(type).append("=\"${1}\";\n");
        buf.append("}}\n");
    }

    private static void appendCommentJiraFormatterRules(StringBuilder buf, String url, String[] projectKeys) {
        StringBuilder regexp = new StringBuilder();
        regexp.append("(?i)(?:[^-\\w]|^)((");
        String sep = "";
        for (String key : projectKeys) {
            regexp.append(sep).append(Pattern.quote(key));
            sep = "|";
        }
        regexp.append(")-\\d{1,9})");
        LinkerFactory.appendCommentFormatterRules(buf, regexp.toString(), url + "/browse/${1}", JIRA_LINK, "${1}");
    }

    private static SyntaxDefinition createSyntaxDefForLinkerDef(LinkerType e2) {
        Object child;
        int i2;
        StringBuilder buf = new StringBuilder("syntaxdef commentparser {\n");
        boolean foundSomething = false;
        for (i2 = 0; i2 < e2.sizeOfSimpleArray(); ++i2) {
            child = e2.getSimpleArray(i2);
            foundSomething = true;
            String re = child.getRegex();
            String href = child.getHref();
            LinkerFactory.appendCommentFormatterRules(buf, re, href);
        }
        for (i2 = 0; i2 < e2.sizeOfAdvancedArray(); ++i2) {
            child = e2.getAdvancedArray(i2).getSyntaxdef();
            foundSomething = true;
            buf.append((String)child).append("\n");
        }
        buf.append("}\n");
        if (!foundSomething) {
            return SyntaxDefinition.PASS_THRU;
        }
        StringReader in = new StringReader(buf.toString());
        LinkedList<String> errors = new LinkedList<String>();
        SyntaxDefinition sd = SyntaxDefinition.parse(in, errors);
        if (errors.isEmpty()) {
            return sd;
        }
        Logs.APP_LOG.warn((Object)"errors parsing comment formatter");
        Logs.APP_LOG.debug((Object)("errors parsing comment formatter, input was:\n" + buf));
        for (String error : errors) {
            Logs.APP_LOG.warn((Object)error);
        }
        return SyntaxDefinition.PASS_THRU;
    }

    public static Linker generateJiraSyntaxDef(Collection<EntityLink> jiraProjects) {
        Linker linker = new Linker();
        if (jiraProjects.isEmpty()) {
            return linker;
        }
        StringBuilder sb = new StringBuilder("syntaxdef JiraProjectKeySyntaxDef {\n");
        for (EntityLink linkedJiraProject : jiraProjects) {
            LinkerFactory.appendCommentJiraFormatterRules(sb, linkedJiraProject.getApplicationLink().getDisplayUrl().toASCIIString(), new String[]{linkedJiraProject.getKey()});
        }
        sb.append("}\n");
        StringReader in = new StringReader(sb.toString());
        LinkedList<String> errors = new LinkedList<String>();
        SyntaxDefinition sd = SyntaxDefinition.parse(in, errors);
        if (!errors.isEmpty()) {
            Logs.APP_LOG.error((Object)("errors parsing mapped generated JIRA linker syntaxdef:\n" + sb));
            for (String error : errors) {
                Logs.APP_LOG.warn((Object)error);
            }
            throw new RuntimeException("Error parsing mapped generated JIRA linker syntaxdef - see Error log for details");
        }
        linker.addHighlighter(sd);
        return linker;
    }

    public static SyntaxDefinition generateAllJiraIssueSyntaxDef() {
        StringBuilder sb = new StringBuilder("syntaxdef JiraProjectKeySyntaxDef {\n");
        LinkerFactory.appendCommentFormatterRules(sb, "(?i)(?:[^-\\w]|^)(([A-Z][A-Z_0-9]{1,49})-\\d{1,9})", NavBuilder.getSiteUrl() + "/action/jira-issue.do?key=${1}", JIRA_LINK, "${1}");
        sb.append("}\n");
        StringReader in = new StringReader(sb.toString());
        LinkedList<String> errors = new LinkedList<String>();
        SyntaxDefinition sd = SyntaxDefinition.parse(in, errors);
        if (!errors.isEmpty()) {
            Logs.APP_LOG.error((Object)("errors parsing generated JIRA proxy linker syntaxdef:\n" + sb));
            for (String error : errors) {
                Logs.APP_LOG.warn((Object)error);
            }
            throw new RuntimeException("Error parsing generated JIRA proxy linker syntaxdef - see Error log for details");
        }
        return sd;
    }

    private static String replace(String str, String find, String replace) {
        StringBuffer result = new StringBuffer(str);
        int start = 0;
        while (-1 != (start = result.indexOf(find, start))) {
            result.replace(start, start + find.length(), replace);
            start += replace.length();
        }
        return result.toString();
    }

    private static class LinkerKey {
        private String projectKey;
        private String repoName;

        private LinkerKey(String repoName, String projectKey) {
            this.projectKey = projectKey;
            this.repoName = repoName;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            LinkerKey linkerKey = (LinkerKey)o2;
            if (this.projectKey != null ? !this.projectKey.equals(linkerKey.projectKey) : linkerKey.projectKey != null) {
                return false;
            }
            return !(this.repoName != null ? !this.repoName.equals(linkerKey.repoName) : linkerKey.repoName != null);
        }

        public int hashCode() {
            int result = this.projectKey != null ? this.projectKey.hashCode() : 0;
            result = 31 * result + (this.repoName != null ? this.repoName.hashCode() : 0);
            return result;
        }
    }
}

