/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import java.util.LinkedList;
import java.util.List;

public class Linker {
    public static final String FINDLINKS_KEY = "findlinks";
    public static final Linker NO_OP = new Linker(){

        @Override
        public void addHighlighter(SyntaxDefinition h2) {
            throw new IllegalStateException("Can't add highlighters to this linker");
        }

        @Override
        public void addHighlighters(Linker other) {
            throw new IllegalStateException("Can't add highlighters to this linker");
        }
    };
    private final List<SyntaxDefinition> mLinkers = new LinkedList<SyntaxDefinition>();

    public void addHighlighter(SyntaxDefinition h2) {
        if (h2 == SyntaxDefinition.PASS_THRU) {
            return;
        }
        this.mLinkers.add(h2);
    }

    public void addHighlighters(Linker other) {
        for (SyntaxDefinition sd : other.mLinkers) {
            this.addHighlighter(sd);
        }
    }

    public void insertLinks(CharSequence in, RegionList regions) {
        for (SyntaxDefinition syn : this.mLinkers) {
            for (Region region : regions.asList()) {
                String fl = region.getPropertyValue(FINDLINKS_KEY);
                if (fl == null || !"true".equalsIgnoreCase(fl)) continue;
                int off = region.getStart();
                InputState is = new InputState(in.subSequence(0, region.getEnd()));
                is.resetOffset(off);
                syn.generateRegions(is, regions);
            }
        }
    }

    public boolean isEmpty() {
        return this.mLinkers.isEmpty();
    }
}

