/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.atlassian.fisheye.jira.JiraServerService;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.cenqua.fisheye.syntax.LinkerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="linkerService")
public class DefaultLinkerService
implements LinkerService {
    @Autowired
    private LinkerFactory linkerFactory;
    @Autowired
    private JiraServerService jiraServerService;
    @Autowired
    private RepositoryManager repositoryManager;
    @Autowired
    private RootConfig rootConfig;

    @Override
    public Linker getLinker(Source source, String projectKey) {
        return this.getLinker(source, projectKey, LinkerService.Type.defaultLinkers());
    }

    @Override
    public Linker getLinker(String repositoryName, String projectKey) {
        return this.getLinker(repositoryName, projectKey, LinkerService.Type.defaultLinkers());
    }

    @Override
    public Linker getRepositoryLinker(String repositoryName) {
        return this.getLinker(repositoryName, null, LinkerService.Type.defaultLinkers());
    }

    @Override
    public Linker getDefaultLinker() {
        return this.getLinker((String)null, null, LinkerService.Type.defaultLinkers());
    }

    @Override
    public Linker getLinker(Source source, String projectKey, LinkerService.Type ... linkers) {
        if (source == null) {
            return this.getLinker((String)null, projectKey, linkers);
        }
        return this.createLinker(source.getLinker(), source.getName(), projectKey, linkers);
    }

    @Override
    public Linker getLinker(String repositoryName, String projectKey, LinkerService.Type ... linkers) {
        Linker repositoryLinker;
        if (repositoryName != null) {
            RepositoryHandle rep = this.repositoryManager.getRepository(repositoryName);
            if (rep == null) {
                Logs.APP_LOG.warn((Object)("Unknown repository " + repositoryName));
                return this.rootConfig.getDefaultLinker();
            }
            repositoryLinker = rep.getCfg().getLinker();
        } else {
            repositoryLinker = this.rootConfig.getDefaultLinker();
        }
        return this.createLinker(repositoryLinker, repositoryName, projectKey, linkers);
    }

    private Linker createLinker(Linker repositoryLinker, String repositoryName, String projectKey, LinkerService.Type ... linkers) {
        Linker linker = new Linker();
        block6: for (LinkerService.Type type : linkers) {
            switch (type) {
                case ISSUE_ENTITY: {
                    if (repositoryName == null && projectKey == null) continue block6;
                    linker.addHighlighters(this.linkerFactory.getJiraLinker(repositoryName, projectKey));
                    continue block6;
                }
                case ISSUE_ALL: {
                    if (!this.jiraServerService.hasJiraApplicationLink()) continue block6;
                    linker.addHighlighter(LinkerFactory.generateAllJiraIssueSyntaxDef());
                    continue block6;
                }
                case REPOSITORY: {
                    linker.addHighlighters(repositoryLinker);
                    continue block6;
                }
                case REVIEW: {
                    linker.addHighlighters(this.linkerFactory.getCrucibleLinker());
                }
            }
        }
        return linker;
    }
}

