/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.ContextReference;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.MatchRule;
import com.cenqua.fisheye.syntax.MultiMatchRule;
import com.cenqua.fisheye.syntax.RegionList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContextDefinition {
    private final String name;
    private List<MatchRule> matchRules = new ArrayList<MatchRule>();
    private MultiMatchRule multiMatchRule;
    private Map<String, ContextDefinition> contexts = new HashMap<String, ContextDefinition>();
    private static final int MAX_REGIONS = 200000;

    public ContextDefinition(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addContextDef(String name, ContextDefinition child) {
        this.contexts.put(name, child);
    }

    public ContextDefinition getContextDef(ContextReference ref) {
        return this.contexts.get(ref.getName());
    }

    public void addMatchRule(MatchRule m2) {
        this.matchRules.add(m2);
        this.multiMatchRule = null;
    }

    public void resolveRefs() {
        for (String name : this.contexts.keySet()) {
            ContextDefinition cd = this.contexts.get(name);
            cd.resolveRefs();
        }
        for (MatchRule matcher : this.matchRules) {
            matcher.resolveRefs(this);
        }
    }

    private MultiMatchRule getMultiMatchRule() {
        if (this.multiMatchRule == null) {
            this.multiMatchRule = new MultiMatchRule(this.matchRules);
        }
        return this.multiMatchRule;
    }

    public void generateRegions(InputState input, RegionList outputRegions) {
        while (input.hasMoreChars()) {
            int offset = input.getOffset();
            if (!this.getMultiMatchRule().process(input, outputRegions)) {
                return;
            }
            if (outputRegions.size() > 200000 || input.isOverTime()) {
                return;
            }
            if (offset != input.getOffset()) continue;
            input.consume();
        }
    }

    public String toString() {
        String res = "ContextDef{name=" + this.name + ";subcontexts={";
        String sep = "";
        for (Map.Entry<String, ContextDefinition> entry : this.contexts.entrySet()) {
            res = res + sep + entry;
            sep = ",";
        }
        res = res + "};matchRules={";
        sep = "";
        for (MatchRule matcher : this.matchRules) {
            res = res + sep + matcher;
            sep = ",";
        }
        res = res + "}}";
        return res;
    }
}

